/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.api.impl.LlapRecordReader;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.io.BatchToRowInputFormat;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.HiveStringUtils;

public class LlapInputFormat
implements InputFormat<NullWritable, VectorizedRowBatch>,
VectorizedInputFormatInterface,
SelfDescribingInputFormatInterface,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final String NONVECTOR_SETTING_MESSAGE = "disable " + HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED.varname + " to work around this error";
    private static final Map<String, VirtualColumn> ALLOWED_VIRTUAL_COLUMNS = Collections.unmodifiableMap(new HashMap<String, VirtualColumn>(){
        {
            this.put(VirtualColumn.ROWID.getName(), VirtualColumn.ROWID);
            this.put(VirtualColumn.ROWISDELETED.getName(), VirtualColumn.ROWISDELETED);
        }
    });
    private final InputFormat<NullWritable, VectorizedRowBatch> sourceInputFormat;
    private final CombineHiveInputFormat.AvoidSplitCombination sourceASC;
    private final Deserializer sourceSerDe;
    final ColumnVectorProducer cvp;
    final ExecutorService executor;
    private static final String hostName = HiveStringUtils.getHostname();
    private final Configuration daemonConf;

    LlapInputFormat(InputFormat sourceInputFormat, Deserializer sourceSerDe, ColumnVectorProducer cvp, ExecutorService executor, Configuration daemonConf) {
        this.executor = executor;
        this.cvp = cvp;
        this.daemonConf = daemonConf;
        this.sourceInputFormat = sourceInputFormat;
        this.sourceASC = sourceInputFormat instanceof CombineHiveInputFormat.AvoidSplitCombination ? (CombineHiveInputFormat.AvoidSplitCombination)sourceInputFormat : null;
        this.sourceSerDe = sourceSerDe;
    }

    public RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        RecordReader<NullWritable, VectorizedRowBatch> noLlap = this.checkLlapSplit(split, job, reporter);
        if (noLlap != null) {
            return noLlap;
        }
        FileSplit fileSplit = (FileSplit)split;
        reporter.setStatus(fileSplit.toString());
        try {
            List tableIncludedCols = ColumnProjectionUtils.isReadAllColumns((Configuration)job) ? null : ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
            RecordReader<NullWritable, VectorizedRowBatch> rr = LlapRecordReader.create(job, fileSplit, tableIncludedCols, hostName, this.cvp, this.executor, this.sourceInputFormat, this.sourceSerDe, reporter, this.daemonConf);
            if (rr == null) {
                return this.sourceInputFormat.getRecordReader(split, job, reporter);
            }
            RecordReader<NullWritable, VectorizedRowBatch> result = rr;
            if (!Utilities.getIsVectorized((Configuration)job)) {
                result = null;
                if (HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ROW_WRAPPER_ENABLED)) {
                    result = this.wrapLlapReader(tableIncludedCols, (LlapRecordReader)rr, split);
                }
                if (result == null) {
                    return this.sourceInputFormat.getRecordReader(split, job, reporter);
                }
            }
            rr.start();
            return result;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            Throwable rootCause = JavaUtils.findRootCause((Throwable)ex);
            if (this.checkLimitReached(job) && (rootCause instanceof InterruptedException || rootCause instanceof ClosedByInterruptException)) {
                LlapIoImpl.LOG.info("Ignoring exception while getting record reader as limit is reached", rootCause);
                return new NullRowsInputFormat.NullRowsRecordReader((Configuration)job, split);
            }
            throw new IOException(ex);
        }
    }

    private boolean checkLimitReached(JobConf job) {
        return LimitOperator.checkLimitReachedForVertex((JobConf)job, (String)job.get("tez.mapreduce.vertex.name"));
    }

    private RecordReader<NullWritable, VectorizedRowBatch> wrapLlapReader(List<Integer> includedCols, LlapRecordReader rr, InputSplit split) throws IOException {
        if (this.sourceInputFormat instanceof BatchToRowInputFormat) {
            LlapIoImpl.LOG.info("Using batch-to-row converter for split: " + String.valueOf(split));
            return LlapInputFormat.bogusCast(((BatchToRowInputFormat)this.sourceInputFormat).getWrapper((RecordReader)rr, rr.getVectorizedRowBatchCtx(), includedCols));
        }
        LlapIoImpl.LOG.warn("Not using LLAP IO for an unsupported split: " + String.valueOf(split));
        return null;
    }

    public RecordReader<NullWritable, VectorizedRowBatch> checkLlapSplit(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        boolean useLlapIo = true;
        if (split instanceof LlapAwareSplit) {
            useLlapIo = ((LlapAwareSplit)split).canUseLlapIo((Configuration)job);
        }
        if (useLlapIo) {
            return null;
        }
        LlapIoImpl.LOG.warn("Not using LLAP IO for an unsupported split: " + String.valueOf(split));
        return this.sourceInputFormat.getRecordReader(split, job, reporter);
    }

    private static <A, B, C, D> RecordReader<A, B> bogusCast(RecordReader<C, D> rr) {
        return rr;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.sourceInputFormat.getSplits(job, numSplits);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return this.sourceASC == null ? false : this.sourceASC.shouldSkipCombine(path, conf);
    }

    static VectorizedRowBatchCtx createFakeVrbCtx(MapWork mapWork) throws HiveException {
        LinkedHashMap partSpec;
        PartitionDesc partDesc;
        RowSchema rowSchema = LlapInputFormat.findTsOp(mapWork).getSchema();
        ArrayList<String> colNames = new ArrayList<String>(rowSchema.getSignature().size());
        ArrayList<TypeInfo> colTypes = new ArrayList<TypeInfo>(rowSchema.getSignature().size());
        ArrayList<VirtualColumn> virtualColumnList = new ArrayList<VirtualColumn>(2);
        for (ColumnInfo c : rowSchema.getSignature()) {
            String columnName = c.getInternalName();
            if (ALLOWED_VIRTUAL_COLUMNS.containsKey(columnName)) {
                virtualColumnList.add(ALLOWED_VIRTUAL_COLUMNS.get(columnName));
            } else if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)columnName)) continue;
            colNames.add(columnName);
            colTypes.add(TypeInfoUtils.getTypeInfoFromTypeString((String)c.getTypeName()));
        }
        int partitionColumnCount = 0;
        Iterator paths = mapWork.getPathToAliases().keySet().iterator();
        if (paths.hasNext() && (partDesc = (PartitionDesc)mapWork.getPathToPartitionInfo().get(paths.next())) != null && (partSpec = partDesc.getPartSpec()) != null && !partSpec.isEmpty()) {
            partitionColumnCount = partSpec.size();
        }
        VirtualColumn[] virtualColumns = virtualColumnList.toArray(new VirtualColumn[0]);
        return new VectorizedRowBatchCtx(colNames.toArray(new String[colNames.size()]), colTypes.toArray(new TypeInfo[colTypes.size()]), null, null, partitionColumnCount, virtualColumns.length, virtualColumns, new String[0], null);
    }

    static TableScanOperator findTsOp(MapWork mapWork) throws HiveException {
        if (mapWork.getAliasToWork() == null) {
            throw new HiveException("Unexpected - aliasToWork is missing; " + NONVECTOR_SETTING_MESSAGE);
        }
        Iterator ops = mapWork.getAliasToWork().values().iterator();
        TableScanOperator tableScanOperator = null;
        while (ops.hasNext()) {
            Operator op = (Operator)ops.next();
            if (!(op instanceof TableScanOperator)) continue;
            if (tableScanOperator != null) {
                throw new HiveException("Unexpected - more than one TSOP; " + NONVECTOR_SETTING_MESSAGE);
            }
            tableScanOperator = (TableScanOperator)op;
        }
        return tableScanOperator;
    }

    public VectorizedSupport.Support[] getSupportedFeatures() {
        return new VectorizedSupport.Support[]{VectorizedSupport.Support.DECIMAL_64};
    }
}

