/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AbortedTxnHandler
implements QueryHandler<Set<CompactionInfo>> {
    private final long abortedTimeThreshold;
    private final int abortedThreshold;
    private final boolean checkAbortedTimeThreshold;
    private final long systemTime;
    private final int fetchSize;

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return databaseProduct.addLimitClause(this.fetchSize, " \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TXN_STARTED\"), COUNT(*) FROM \"TXNS\", \"TXN_COMPONENTS\"  WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = :state GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" ");
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("state", (Object)TxnStatus.ABORTED.getSqlConst(), 1);
    }

    public Set<CompactionInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        while (rs.next()) {
            boolean pastTimeThreshold = this.checkAbortedTimeThreshold && rs.getLong(4) + this.abortedTimeThreshold < this.systemTime;
            int numAbortedTxns = rs.getInt(5);
            if (numAbortedTxns <= this.abortedThreshold && !pastTimeThreshold) continue;
            CompactionInfo candidate = new CompactionInfo();
            candidate.dbname = rs.getString(1);
            candidate.tableName = rs.getString(2);
            candidate.partName = rs.getString(3);
            candidate.tooManyAborts = numAbortedTxns > this.abortedThreshold;
            candidate.hasOldAbort = pastTimeThreshold;
            response.add(candidate);
        }
        return response;
    }

    public AbortedTxnHandler(long abortedTimeThreshold, int abortedThreshold, int fetchSize) {
        this.abortedTimeThreshold = abortedTimeThreshold;
        this.abortedThreshold = abortedThreshold;
        this.fetchSize = fetchSize;
        this.checkAbortedTimeThreshold = abortedTimeThreshold >= 0L;
        this.systemTime = System.currentTimeMillis();
    }
}

