/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.IMetaStoreIncompatibleChangeHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncompatibleTableChangeHandler
implements IMetaStoreIncompatibleChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIncompatibleTableChangeHandler.class);
    private static final DefaultIncompatibleTableChangeHandler INSTANCE = new DefaultIncompatibleTableChangeHandler();

    private DefaultIncompatibleTableChangeHandler() {
    }

    public static DefaultIncompatibleTableChangeHandler get() {
        return INSTANCE;
    }

    @Override
    public void allowChange(Configuration conf, Table oldTable, Table newTable) throws InvalidOperationException {
        if (!MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES)) {
            return;
        }
        if (oldTable.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
            return;
        }
        this.checkColTypeChangeCompatible(conf, oldTable, newTable);
    }

    private void checkColTypeChangeCompatible(Configuration conf, Table oldTable, Table newTable) throws InvalidOperationException {
        List oldCols = oldTable.getSd().getCols();
        List newCols = newTable.getSd().getCols();
        ArrayList<String> incompatibleCols = new ArrayList<String>();
        int maxCols = Math.min(oldCols.size(), newCols.size());
        for (int i = 0; i < maxCols; ++i) {
            if (ColumnType.areColTypesCompatible((String)ColumnType.getTypeName((String)((FieldSchema)oldCols.get(i)).getType()), (String)ColumnType.getTypeName((String)((FieldSchema)newCols.get(i)).getType()))) continue;
            incompatibleCols.add(((FieldSchema)newCols.get(i)).getName());
        }
        if (!incompatibleCols.isEmpty()) {
            String serializationLib;
            Collection exceptedTableSerdes = MetastoreConf.getStringCollection((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ALLOW_INCOMPATIBLE_COL_TYPE_CHANGES_TABLE_SERDES);
            SerDeInfo serDeInfo = oldTable.getSd().getSerdeInfo();
            String string = serializationLib = serDeInfo == null ? null : serDeInfo.getSerializationLib();
            if (exceptedTableSerdes.contains(serializationLib)) {
                LOG.info("Allowing incompatible column type change of {} for table {} since the table serde {} is in excepted list of serdes", new Object[]{incompatibleCols, oldTable.getDbName() + "." + oldTable.getTableName(), serializationLib});
                return;
            }
            throw new InvalidOperationException("The following columns have types incompatible with the existing columns in their respective positions :\n" + StringUtils.join(incompatibleCols, (char)','));
        }
    }
}

