/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.xa;

import com.xugu.cloudjdbc.Error;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImp
implements XAResource {
    private Xid reXid;
    private XAConnection resXACon;
    private Connection execCon;
    private Statement exeStm;
    private boolean xaIsEnd;
    private boolean xaIsRollback;
    private static String commitSql = "commit";
    private static String rollbackSql = "rollback";
    private static String beginSql = "begin transaction";

    protected XAResourceImp(XAConnection xaCon) {
        this.resXACon = xaCon;
    }

    @Override
    public void commit(Xid xid, boolean b) throws XAException {
        this.checkXid(xid);
        String sqlCommand = null;
        sqlCommand = this.xaIsRollback ? rollbackSql : commitSql;
        this.dispacthCommand(sqlCommand);
        this.resumXAState();
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        this.checkXid(xid);
        switch (i) {
            case 0x4000000: {
                this.xaIsEnd = true;
                break;
            }
            case 0x20000000: {
                this.xaIsRollback = true;
                this.xaIsEnd = true;
                break;
            }
            case 0x2000000: {
                throw Error.createXAException("[E53002] \u6682\u4e0d\u652f\u6301\u7684\u4e8b\u52a1\u5c5e\u6027", 53002);
            }
            default: {
                throw Error.createXAException("[E53003] \u9519\u8bef\u7684\u4e8b\u52a1\u5c5e\u6027", 53003);
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkXid(xid);
        return 0;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        Xid[] returnXid = null;
        returnXid = this.xaIsEnd ? new Xid[]{this.reXid} : new Xid[]{};
        return returnXid;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkXid(xid);
        this.dispacthCommand(rollbackSql);
        this.resumXAState();
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        if (xid == null) {
            throw XAResourceImp.xidException();
        }
        switch (i) {
            case 0: {
                this.dispacthCommand(beginSql);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                throw Error.createXAException("[E53002] \u6682\u4e0d\u652f\u6301\u7684\u4e8b\u52a1\u5c5e\u6027", 53002);
            }
            default: {
                throw Error.createXAException("[E53003] \u9519\u8bef\u7684\u4e8b\u52a1\u5c5e\u6027", 53003);
            }
        }
        this.reXid = xid;
    }

    private void checkXid(Xid xid) throws XAException {
        if (xid == null || this.reXid == null || !xid.equals(this.reXid)) {
            throw XAResourceImp.xidException();
        }
    }

    private void dispacthCommand(String sqlCommand) throws XAException {
        try {
            if (this.execCon == null) {
                this.execCon = this.resXACon.getConnection();
                this.exeStm = this.execCon.createStatement();
            }
            this.exeStm.execute(sqlCommand);
        }
        catch (SQLException e) {
            throw Error.createXAExceptionFromSQLException(e);
        }
    }

    private void resumXAState() {
        this.xaIsEnd = false;
        this.xaIsRollback = false;
    }

    public static XAException xidException() {
        return Error.createXAException("[E53001] Xid\u5f02\u5e38", 53001);
    }
}

