/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.spi;

import com.alibaba.nacos.common.spi.ServiceLoaderException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class NacosServiceLoader {
    private static final Map<Class<?>, Collection<Class<?>>> SERVICES = new ConcurrentHashMap();

    public static <T> Collection<T> load(Class<T> service) {
        if (SERVICES.containsKey(service)) {
            return NacosServiceLoader.newServiceInstances(service);
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T each : ServiceLoader.load(service)) {
            result.add(each);
            NacosServiceLoader.cacheServiceClass(service, each);
        }
        return result;
    }

    private static <T> void cacheServiceClass(Class<T> service, T instance) {
        if (!SERVICES.containsKey(service)) {
            SERVICES.put(service, new LinkedHashSet());
        }
        SERVICES.get(service).add(instance.getClass());
    }

    public static <T> Collection<T> newServiceInstances(Class<T> service) {
        return SERVICES.containsKey(service) ? NacosServiceLoader.newServiceInstancesFromCache(service) : Collections.emptyList();
    }

    private static <T> Collection<T> newServiceInstancesFromCache(Class<T> service) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Class<?> each : SERVICES.get(service)) {
            result.add(NacosServiceLoader.newServiceInstance(each));
        }
        return result;
    }

    private static Object newServiceInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceLoaderException(clazz, e);
        }
    }
}

