/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ResourceConfiguration;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.AttributeListFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeNameValueModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.DetectorAttributesModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.DetectorsModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ResourceModel;
import io.opentelemetry.sdk.internal.GlobUtil;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class ResourceFactory
implements Factory<ResourceModel, Resource> {
    private static final ResourceFactory INSTANCE = new ResourceFactory();

    private ResourceFactory() {
    }

    static ResourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource create(ResourceModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        List<AttributeNameValueModel> attributeNameValueModel;
        ResourceBuilder builder = Resource.getDefault().toBuilder();
        ResourceBuilder detectedResourceBuilder = Resource.builder();
        List<Resource> resourceDetectorResources = ResourceFactory.loadFromResourceDetectors(spiHelper);
        for (Resource resourceProviderResource : resourceDetectorResources) {
            detectedResourceBuilder.putAll(resourceProviderResource);
        }
        Predicate<String> detectorAttributeFilter = ResourceFactory.detectorAttributeFilter(model.getDetectors());
        builder.putAll(detectedResourceBuilder.build().getAttributes().toBuilder().removeIf(attributeKey -> !detectorAttributeFilter.test(attributeKey.getKey())).build()).build();
        String attributeList = model.getAttributesList();
        if (attributeList != null) {
            builder.putAll(ResourceConfiguration.createEnvironmentResource((ConfigProperties)DefaultConfigProperties.createFromMap(Collections.singletonMap("otel.resource.attributes", attributeList))));
        }
        if ((attributeNameValueModel = model.getAttributes()) != null) {
            builder.putAll(AttributeListFactory.getInstance().create(attributeNameValueModel, spiHelper, closeables)).build();
        }
        return builder.build();
    }

    private static List<Resource> loadFromResourceDetectors(SpiHelper spiHelper) {
        List componentProviders = spiHelper.load(ComponentProvider.class);
        ArrayList<ResourceAndOrder> resourceAndOrders = new ArrayList<ResourceAndOrder>();
        for (ComponentProvider componentProvider : componentProviders) {
            Resource resource;
            if (componentProvider.getType() != Resource.class) continue;
            try {
                resource = (Resource)componentProvider.create(DeclarativeConfigProperties.empty());
            }
            catch (Throwable throwable) {
                throw new DeclarativeConfigException("Error configuring " + Resource.class.getName() + " with name \"" + componentProvider.getName() + "\"", throwable);
            }
            int order = componentProvider instanceof Ordered ? ((Ordered)componentProvider).order() : 0;
            resourceAndOrders.add(new ResourceAndOrder(resource, order));
        }
        resourceAndOrders.sort(Comparator.comparing(rec$ -> ((ResourceAndOrder)rec$).order()));
        return resourceAndOrders.stream().map(rec$ -> ((ResourceAndOrder)rec$).resource()).collect(Collectors.toList());
    }

    private static boolean matchAll(String attributeKey) {
        return true;
    }

    private static Predicate<String> detectorAttributeFilter(@Nullable DetectorsModel detectorsModel) {
        if (detectorsModel == null) {
            return ResourceFactory::matchAll;
        }
        DetectorAttributesModel detectorAttributesModel = detectorsModel.getAttributes();
        if (detectorAttributesModel == null) {
            return ResourceFactory::matchAll;
        }
        List<String> included = detectorAttributesModel.getIncluded();
        List<String> excluded = detectorAttributesModel.getExcluded();
        if (included == null && excluded == null) {
            return ResourceFactory::matchAll;
        }
        if (included == null) {
            return ResourceFactory.excludedPredicate(excluded);
        }
        if (excluded == null) {
            return ResourceFactory.includedPredicate(included);
        }
        return ResourceFactory.includedPredicate(included).and(ResourceFactory.excludedPredicate(excluded));
    }

    private static Predicate<String> includedPredicate(List<String> included) {
        Predicate<String> result = attributeKey -> false;
        for (String include : included) {
            result = result.or(GlobUtil.toGlobPatternPredicate((String)include));
        }
        return result;
    }

    private static Predicate<String> excludedPredicate(List<String> excluded) {
        Predicate<String> result = attributeKey -> true;
        for (String exclude : excluded) {
            result = result.and(GlobUtil.toGlobPatternPredicate((String)exclude).negate());
        }
        return result;
    }

    private static final class ResourceAndOrder {
        private final Resource resource;
        private final int order;

        private ResourceAndOrder(Resource resource, int order) {
            this.resource = resource;
            this.order = order;
        }

        private Resource resource() {
            return this.resource;
        }

        private int order() {
            return this.order;
        }
    }
}

