/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;

public class IntSortedList
implements Mutable {
    private int[] buffer;
    private int size;

    public IntSortedList() {
        this(8);
    }

    private IntSortedList(int size) {
        this.buffer = new int[size];
        this.size = 0;
    }

    public void add(int value) {
        int p = this.binSearch(value);
        if (this.size == this.buffer.length) {
            this.resize();
        }
        if (p < this.size) {
            System.arraycopy(this.buffer, p, this.buffer, p + 1, this.size - p);
        }
        this.buffer[p] = value;
        ++this.size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = 0;
        }
        this.size = 0;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public int poll() {
        int v = this.buffer[0];
        if (this.size > 0) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, --this.size);
        }
        return v;
    }

    public int size() {
        return this.size;
    }

    private int binSearch(int v) {
        int low = 0;
        int high = this.size;
        while (high - low > 65) {
            int mid = low + high - 1 >>> 1;
            int midVal = this.buffer[mid];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            while (++mid < high && this.buffer[mid] == v) {
            }
            return mid;
        }
        return this.scanSearch(v, low);
    }

    private void resize() {
        int[] tmp = new int[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
        this.buffer = tmp;
    }

    private int scanSearch(int v, int low) {
        for (int i = low; i < this.size; ++i) {
            if (this.buffer[i] <= v) continue;
            return i;
        }
        return this.size;
    }
}

