/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import java.util.concurrent.locks.LockSupport;

public class SOCountDownLatch
implements CountDownLatchSPI {
    private static final long VALUE_OFFSET = Unsafe.getFieldOffset(SOCountDownLatch.class, "count");
    private volatile int count;
    private volatile Thread waiter;

    public SOCountDownLatch(int count) {
        this.count = count;
    }

    public SOCountDownLatch() {
    }

    public void await() {
        this.waiter = Thread.currentThread();
        while (this.getCount() > 0) {
            Os.park();
        }
    }

    public boolean await(long nanos) {
        this.waiter = Thread.currentThread();
        if (this.getCount() == 0) {
            return true;
        }
        while (true) {
            long start = System.nanoTime();
            LockSupport.parkNanos(nanos);
            long elapsed = System.nanoTime() - start;
            if (elapsed >= nanos) break;
            if (this.getCount() == 0) {
                return true;
            }
            nanos -= elapsed;
        }
        return this.getCount() == 0;
    }

    @Override
    public void countDown() {
        int current;
        while ((current = this.getCount()) >= 1) {
            int next = current - 1;
            if (!Unsafe.cas((Object)this, VALUE_OFFSET, current, next)) continue;
            if (next != 0) break;
            this.unparkWaiter();
            break;
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    private void unparkWaiter() {
        Thread waiter = this.waiter;
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }
}

