/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.HttpLogRecordUtf8Sink;
import io.questdb.log.Log;
import io.questdb.log.LogAlertSocket;
import io.questdb.log.LogError;
import io.questdb.log.LogFactory;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.LogWriter;
import io.questdb.log.TemplateParser;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import java.io.InputStream;

public class LogAlertSocketWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    public static final CharSequenceObjHashMap<CharSequence> ALERT_PROPS = TemplateParser.adaptMap(System.getenv());
    public static final String DEFAULT_ALERT_TPT_FILE = "/alert-manager-tpt.json";
    private static final String CLUSTER_ENV = "CLUSTER_NAME";
    private static final String DEFAULT_ENV_VALUE = "GLOBAL";
    private static final String INSTANCE_ENV = "INSTANCE_NAME";
    private static final String MESSAGE_ENV = "ALERT_MESSAGE";
    private static final String MESSAGE_ENV_VALUE = "${ALERT_MESSAGE}";
    private static final String NAMESPACE_ENV = "NAMESPACE";
    private static final String ORG_ID_ENV = "ORGID";
    private final TemplateParser alertTemplate = new TemplateParser();
    private final RingQueue<LogRecordUtf8Sink> alertsSourceQueue;
    private final MicrosecondClock clock;
    private final FilesFacade ff;
    private final int level;
    private final NetworkFacade nf;
    private final CharSequenceObjHashMap<CharSequence> properties;
    private final Utf8StringSink sink = new Utf8StringSink();
    private final SCSequence writeSequence;
    private HttpLogRecordUtf8Sink alertSink;
    private String alertTargets;
    private ObjList<TemplateParser.TemplateNode> alertTemplateNodes;
    private int alertTemplateNodesLen;
    private String defaultAlertHost;
    private String defaultAlertPort;
    private String inBufferSize;
    private String location;
    private Log log;
    private String outBufferSize;
    private String reconnectDelay;
    private LogAlertSocket socket;
    private final QueueConsumer<LogRecordUtf8Sink> alertsProcessor = this::onLogRecord;

    public LogAlertSocketWriter(RingQueue<LogRecordUtf8Sink> alertsSrc, SCSequence writeSequence, int level) {
        this(FilesFacadeImpl.INSTANCE, NetworkFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, alertsSrc, writeSequence, level, ALERT_PROPS);
    }

    public LogAlertSocketWriter(FilesFacade ff, NetworkFacade nf, MicrosecondClock clock, RingQueue<LogRecordUtf8Sink> alertsSrc, SCSequence writeSequence, int level, CharSequenceObjHashMap<CharSequence> properties) {
        this.ff = ff;
        this.nf = nf;
        this.clock = clock;
        this.alertsSourceQueue = alertsSrc;
        this.writeSequence = writeSequence;
        this.level = level & ~(1 << Numbers.msb(LogLevel.ADVISORY));
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(String location, long address, long addressSize, FilesFacade ff, Utf8Sink sink) {
        long templateFd = -1L;
        try (Path path = new Path();){
            if (Os.isWindows() && location.charAt(0) == '/') {
                path.of(location, 1, location.length());
            } else {
                path.of(location);
            }
            templateFd = ff.openRO(path.$());
            if (templateFd == -1L) {
                throw new LogError(String.format("Cannot read %s [errno=%d]", location, ff.errno()));
            }
            long size = ff.length(templateFd);
            if (size > addressSize) {
                throw new LogError("Template file is too big");
            }
            if (size < 0L || size != ff.read(templateFd, address, size, 0L)) {
                throw new LogError(String.format("Cannot read %s [errno=%d, size=%d]", location, ff.errno(), size));
            }
            Utf8s.strCpy(address, address + size, sink);
        }
        finally {
            ff.close(templateFd);
        }
    }

    @Override
    public void bindProperties(LogFactory factory) {
        int nInBufferSize = 0x200000;
        if (this.inBufferSize != null) {
            try {
                nInBufferSize = Numbers.parseIntSize(this.inBufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for inBufferSize: " + this.inBufferSize);
            }
        }
        int nOutBufferSize = 0x400000;
        if (this.outBufferSize != null) {
            try {
                nOutBufferSize = Numbers.parseIntSize(this.outBufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for outBufferSize: " + this.outBufferSize);
            }
        }
        long nReconnectDelay = 250000000L;
        if (this.reconnectDelay != null) {
            try {
                nReconnectDelay = Numbers.parseLong(this.reconnectDelay) * 1000000L;
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for reconnectDelay: " + this.reconnectDelay);
            }
        }
        if (this.defaultAlertHost == null) {
            this.defaultAlertHost = "127.0.0.1";
        }
        int nDefaultPort = 9093;
        if (this.defaultAlertPort != null) {
            try {
                nDefaultPort = Numbers.parseInt(this.defaultAlertPort);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for defaultAlertPort: " + this.defaultAlertPort);
            }
        }
        this.log = factory.create(LogAlertSocketWriter.class.getName());
        this.socket = new LogAlertSocket(this.nf, this.alertTargets, nInBufferSize, nOutBufferSize, nReconnectDelay, this.defaultAlertHost, nDefaultPort, this.log);
        this.alertSink = new HttpLogRecordUtf8Sink(this.socket).putHeader(LogAlertSocket.localHostIp).setMark();
        this.loadLogAlertTemplate();
        this.socket.connect();
    }

    @Override
    public void close() {
        Misc.free(this.socket);
    }

    public HttpLogRecordUtf8Sink getAlertSink() {
        return this.alertSink;
    }

    public String getAlertTargets() {
        return this.socket.getAlertTargets();
    }

    public String getDefaultAlertHost() {
        return this.socket.getDefaultAlertHost();
    }

    public int getDefaultAlertPort() {
        return this.socket.getDefaultAlertPort();
    }

    public int getInBufferSize() {
        return this.socket.getInBufferSize();
    }

    public String getLocation() {
        return this.location;
    }

    public int getOutBufferSize() {
        return this.socket.getOutBufferSize();
    }

    public long getReconnectDelay() {
        return this.socket.getReconnectDelay();
    }

    public void onLogRecord(LogRecordUtf8Sink logRecord) {
        int len = logRecord.size();
        if ((logRecord.getLevel() & this.level) != 0 && len > 0) {
            this.alertTemplate.setDateValue(this.clock.getTicks());
            this.alertSink.rewindToMark();
            for (int i = 0; i < this.alertTemplateNodesLen; ++i) {
                TemplateParser.TemplateNode comp = this.alertTemplateNodes.getQuick(i);
                if (comp.isEnv(MESSAGE_ENV)) {
                    this.alertSink.put(logRecord);
                    continue;
                }
                this.alertSink.put(comp);
            }
            this.sink.clear();
            this.sink.put((Utf8Sequence)logRecord);
            this.sink.clear(this.sink.size() - "\r\n".length());
            this.log.info().$("Sending: ").$(this.sink).$();
            this.socket.send(this.alertSink.$());
        }
    }

    @Override
    public boolean runSerially() {
        return this.writeSequence.consumeAll(this.alertsSourceQueue, this.alertsProcessor);
    }

    public void setAlertTargets(String alertTargets) {
        this.alertTargets = alertTargets;
    }

    public void setDefaultAlertHost(String defaultAlertHost) {
        this.defaultAlertHost = defaultAlertHost;
    }

    public void setDefaultAlertPort(String defaultAlertPort) {
        this.defaultAlertPort = defaultAlertPort;
    }

    public void setInBufferSize(String inBufferSize) {
        this.inBufferSize = inBufferSize;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setOutBufferSize(String outBufferSize) {
        this.outBufferSize = outBufferSize;
    }

    public void setReconnectDelay(String reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    private void loadLogAlertTemplate() {
        long now = this.clock.getTicks();
        if (this.location == null || this.location.isEmpty()) {
            this.location = DEFAULT_ALERT_TPT_FILE;
        }
        this.location = this.alertTemplate.parseEnv(this.location, now).toString();
        boolean needsReading = true;
        try (InputStream is = LogAlertSocketWriter.class.getResourceAsStream(this.location);){
            if (is != null) {
                byte[] buff = new byte[0x200000];
                int len = is.read(buff, 0, buff.length);
                String template = new String(buff, 0, len, Files.UTF_8);
                this.alertTemplate.parse((CharSequence)template, now, this.properties);
                needsReading = false;
            }
        }
        catch (LogError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (needsReading) {
            this.sink.clear();
            LogAlertSocketWriter.readFile(this.location, this.socket.getInBufferPtr(), this.socket.getInBufferSize(), this.ff, this.sink);
            this.alertTemplate.parse((CharSequence)Utf8s.toString(this.sink), now, this.properties);
        }
        if (this.alertTemplate.getKeyOffset(MESSAGE_ENV) < 0) {
            throw new LogError(String.format("Bad template, no %s declaration found %s", MESSAGE_ENV_VALUE, this.location));
        }
        this.alertTemplateNodes = this.alertTemplate.getTemplateNodes();
        this.alertTemplateNodesLen = this.alertTemplateNodes.size();
    }

    static {
        if (!ALERT_PROPS.contains(ORG_ID_ENV)) {
            ALERT_PROPS.put(ORG_ID_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(NAMESPACE_ENV)) {
            ALERT_PROPS.put(NAMESPACE_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(CLUSTER_ENV)) {
            ALERT_PROPS.put(CLUSTER_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(INSTANCE_ENV)) {
            ALERT_PROPS.put(INSTANCE_ENV, DEFAULT_ENV_VALUE);
        }
        ALERT_PROPS.put(MESSAGE_ENV, MESSAGE_ENV_VALUE);
    }
}

