/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.window;

import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.Mutable;
import org.jetbrains.annotations.Nullable;

public class WindowContextImpl
implements WindowContext,
Mutable {
    private boolean baseSupportsRandomAccess;
    private boolean empty = true;
    private int exclusionKind;
    private int exclusionKindPos;
    private int framingMode;
    private boolean ignoreNulls;
    private int nullsDescPos;
    private int orderByDirection;
    private int orderByPos;
    private boolean ordered;
    private ColumnTypes partitionByKeyTypes;
    private VirtualRecord partitionByRecord;
    private RecordSink partitionBySink;
    private long rowsHi;
    private int rowsHiKindPos;
    private long rowsLo;
    private int rowsLoKindPos;
    private int timestampIndex;

    @Override
    public boolean baseSupportsRandomAccess() {
        return this.baseSupportsRandomAccess;
    }

    @Override
    public void clear() {
        this.empty = true;
        this.partitionByRecord = null;
        this.partitionBySink = null;
        this.partitionByKeyTypes = null;
        this.ordered = false;
        this.orderByDirection = 0;
        this.orderByPos = 0;
        this.baseSupportsRandomAccess = false;
        this.framingMode = 2;
        this.rowsLo = Long.MIN_VALUE;
        this.rowsHi = Long.MAX_VALUE;
        this.exclusionKind = 4;
        this.rowsLoKindPos = 0;
        this.rowsHiKindPos = 0;
        this.exclusionKindPos = 0;
        this.timestampIndex = -1;
        this.ignoreNulls = false;
        this.nullsDescPos = 0;
    }

    @Override
    public int getExclusionKind() {
        return this.exclusionKind;
    }

    @Override
    public int getExclusionKindPos() {
        return this.exclusionKindPos;
    }

    @Override
    public int getFramingMode() {
        return this.framingMode;
    }

    @Override
    public int getNullsDescPos() {
        return this.nullsDescPos;
    }

    @Override
    public int getOrderByPos() {
        return this.orderByPos;
    }

    @Override
    public ColumnTypes getPartitionByKeyTypes() {
        return this.partitionByKeyTypes;
    }

    @Override
    public VirtualRecord getPartitionByRecord() {
        return this.partitionByRecord;
    }

    @Override
    public RecordSink getPartitionBySink() {
        return this.partitionBySink;
    }

    @Override
    public long getRowsHi() {
        if (this.exclusionKind == 1 && this.rowsHi == 0L) {
            return -1L;
        }
        return this.rowsHi;
    }

    @Override
    public int getRowsHiKindPos() {
        return this.rowsHiKindPos;
    }

    @Override
    public long getRowsLo() {
        return this.rowsLo;
    }

    @Override
    public int getRowsLoKindPos() {
        return this.rowsLoKindPos;
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    @Override
    public boolean isDefaultFrame() {
        return this.framingMode == 1 && this.rowsLo == Long.MIN_VALUE && (this.rowsHi == 0L || this.rowsHi == Long.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public boolean isOrderedByDesignatedTimestamp() {
        return this.orderByDirection == 1 || this.orderByDirection == 2;
    }

    public void of(VirtualRecord partitionByRecord, @Nullable RecordSink partitionBySink, @Nullable ColumnTypes partitionByKeyTypes, boolean ordered, int orderByDirection, int orderByPos, boolean baseSupportsRandomAccess, int framingMode, long rowsLo, int rowsLoKindPos, long rowsHi, int rowsHiKindPos, int exclusionKind, int exclusionKindPos, int timestampIndex, boolean ignoreNulls, int nullsDescPos) {
        this.empty = false;
        this.partitionByRecord = partitionByRecord;
        this.partitionBySink = partitionBySink;
        this.partitionByKeyTypes = partitionByKeyTypes;
        this.ordered = ordered;
        this.orderByDirection = orderByDirection;
        this.orderByPos = orderByPos;
        this.baseSupportsRandomAccess = baseSupportsRandomAccess;
        this.framingMode = framingMode;
        this.rowsLo = rowsLo;
        this.rowsLoKindPos = rowsLoKindPos;
        this.rowsHi = rowsHi;
        this.rowsHiKindPos = rowsHiKindPos;
        this.exclusionKind = exclusionKind;
        this.exclusionKindPos = exclusionKindPos;
        this.timestampIndex = timestampIndex;
        this.ignoreNulls = ignoreNulls;
        this.nullsDescPos = nullsDescPos;
    }

    @Override
    public void validate(int position, boolean supportTNullsDesc) throws SqlException {
        if (this.isEmpty()) {
            throw SqlException.emptyWindowContext(position);
        }
        if (this.getNullsDescPos() > 0 && !supportTNullsDesc) {
            throw SqlException.$(this.getNullsDescPos(), "RESPECT/IGNORE NULLS is not supported for current window function");
        }
        if (!this.isDefaultFrame()) {
            if (this.rowsLo > 0L) {
                throw SqlException.$(this.getRowsLoKindPos(), "frame start supports UNBOUNDED PRECEDING, _number_ PRECEDING and CURRENT ROW only");
            }
            if (this.rowsHi > 0L) {
                if (this.rowsHi != Long.MAX_VALUE) {
                    throw SqlException.$(this.getRowsHiKindPos(), "frame end supports _number_ PRECEDING and CURRENT ROW only");
                }
                if (this.rowsLo != Long.MIN_VALUE) {
                    throw SqlException.$(this.getRowsHiKindPos(), "frame end supports UNBOUNDED FOLLOWING only when frame start is UNBOUNDED PRECEDING");
                }
            }
        }
        int exclusionKind = this.getExclusionKind();
        int exclusionKindPos = this.getExclusionKindPos();
        if (exclusionKind != 4 && exclusionKind != 1) {
            throw SqlException.$(exclusionKindPos, "only EXCLUDE NO OTHERS and EXCLUDE CURRENT ROW exclusion modes are supported");
        }
        if (exclusionKind == 1 && this.rowsHi == Long.MAX_VALUE) {
            throw SqlException.$(exclusionKindPos, "EXCLUDE CURRENT ROW not supported with UNBOUNDED FOLLOWING frame boundary");
        }
        if (this.getFramingMode() == 3) {
            throw SqlException.$(position, "function not implemented for given window parameters");
        }
    }
}

