/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class LatestByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int RECORD_INDEX_VALUE_IDX = 0;
    private static final int TIMESTAMP_VALUE_IDX = 1;
    private final RecordCursorFactory base;
    private final LatestByRecordCursor cursor;
    private final RecordSink recordSink;
    private final DirectLongList rowIndexes;
    private final long rowIndexesInitialCapacity;

    public LatestByRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordCursorFactory base, @NotNull RecordSink recordSink, @NotNull ColumnTypes columnTypes, int timestampIndex) {
        super(base.getMetadata());
        assert (!base.recordCursorSupportsRandomAccess());
        this.base = base;
        this.recordSink = recordSink;
        ArrayColumnTypes mapValueTypes = new ArrayColumnTypes();
        mapValueTypes.add(0, 6);
        mapValueTypes.add(1, 8);
        Map latestByMap = MapFactory.createOrderedMap(configuration, columnTypes, mapValueTypes);
        this.cursor = new LatestByRecordCursor(latestByMap, timestampIndex);
        this.rowIndexesInitialCapacity = configuration.getSqlLatestByRowCount();
        this.rowIndexes = new DirectLongList(this.rowIndexesInitialCapacity, 40);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, this.recordSink, this.rowIndexes, this.rowIndexesInitialCapacity, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestBy");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.free(this.rowIndexes);
        Misc.free(this.cursor);
        Misc.free(this.base);
    }

    private static class LatestByRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Map latestByMap;
        private final int timestampIndex;
        private RecordCursor baseCursor;
        private Record baseRecord;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long index = 0L;
        private boolean isMapBuilt;
        private boolean isOpen;
        private RecordSink recordSink;
        private DirectLongList rowIndexes;
        private long rowIndexesCapacityThreshold;
        private long rowIndexesPos = 0L;

        public LatestByRecordCursor(Map latestByMap, int timestampIndex) {
            this.latestByMap = latestByMap;
            this.timestampIndex = timestampIndex;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.baseCursor = Misc.free(this.baseCursor);
                if (this.rowIndexes != null) {
                    this.rowIndexes.clear();
                    if (this.rowIndexes.getCapacity() > this.rowIndexesCapacityThreshold) {
                        this.rowIndexes.setCapacity(this.rowIndexesCapacityThreshold);
                    }
                }
                this.latestByMap.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.baseRecord;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                this.buildMap();
                this.toTop();
                this.isMapBuilt = true;
            }
            if (this.rowIndexesPos == this.rowIndexes.size()) {
                return false;
            }
            long nextIndex = this.rowIndexes.get(this.rowIndexesPos);
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                if (this.index++ != nextIndex) continue;
                ++this.rowIndexesPos;
                return true;
            }
            return false;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor baseCursor, RecordSink recordSink, DirectLongList rowIndexes, long rowIndexesCapacityThreshold, SqlExecutionCircuitBreaker circuitBreaker) {
            this.baseCursor = baseCursor;
            this.baseRecord = baseCursor.getRecord();
            if (!this.isOpen) {
                this.isOpen = true;
                this.latestByMap.reopen();
            }
            this.recordSink = recordSink;
            this.rowIndexes = rowIndexes;
            this.circuitBreaker = circuitBreaker;
            this.rowIndexesCapacityThreshold = rowIndexesCapacityThreshold;
            this.rowIndexesPos = 0L;
            this.index = 0L;
            this.isMapBuilt = false;
        }

        @Override
        public long preComputedStateSize() {
            return RecordCursor.fromBool(this.isMapBuilt) + this.baseCursor.preComputedStateSize();
        }

        @Override
        public long size() {
            return this.isMapBuilt ? this.rowIndexes.size() : -1L;
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.index = 0L;
            this.rowIndexesPos = 0L;
        }

        private void buildMap() {
            Record baseRecord = this.baseCursor.getRecord();
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.latestByMap.withKey();
                this.recordSink.copy(baseRecord, key);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    value.putLong(0, this.index);
                    value.putTimestamp(1, baseRecord.getTimestamp(this.timestampIndex));
                } else {
                    long prevTimestamp = value.getTimestamp(1);
                    long newTimestamp = baseRecord.getTimestamp(this.timestampIndex);
                    if (newTimestamp >= prevTimestamp) {
                        value.putLong(0, this.index);
                        value.putTimestamp(1, newTimestamp);
                    }
                }
                ++this.index;
            }
            try (MapRecordCursor mapCursor = this.latestByMap.getCursor();){
                MapRecord mapRecord = (MapRecord)mapCursor.getRecord();
                while (mapCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    MapValue value = mapRecord.getValue();
                    long rowId = value.getLong(0);
                    this.rowIndexes.add(rowId);
                }
            }
            this.rowIndexes.sortAsUnsigned();
            this.latestByMap.close();
        }
    }
}

