/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByAllRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByAllFilteredRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private Function filter;

    public LatestByAllFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, @NotNull RecordSink recordSink, @NotNull ColumnTypes columnTypes, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        try {
            this.filter = filter;
            Map map = MapFactory.createOrderedMap(configuration, columnTypes);
            this.cursor = filter == null ? new LatestByAllRecordCursor(configuration, metadata, map, this.rows, recordSink) : new LatestByAllFilteredRecordCursor(configuration, metadata, map, this.rows, recordSink, filter);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByAllFiltered");
        sink.child(this.cursor);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
        this.filter = Misc.free(this.filter);
    }
}

