/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.jit.CompiledFilter;
import io.questdb.std.DirectLongList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncFilterUtils {
    private AsyncFilterUtils() {
    }

    public static void applyCompiledFilter(@NotNull CompiledFilter compiledFilter, @NotNull MemoryCARW bindVarMemory, @NotNull ObjList<Function> bindVarFunctions, @NotNull PageFrameReduceTask task) {
        AsyncFilterUtils.applyCompiledFilter(null, compiledFilter, bindVarMemory, bindVarFunctions, task);
    }

    public static void applyCompiledFilter(@Nullable PageFrameMemory frameMemory, @NotNull CompiledFilter compiledFilter, @NotNull MemoryCARW bindVarMemory, @NotNull ObjList<Function> bindVarFunctions, @NotNull PageFrameReduceTask task) {
        if (frameMemory == null) {
            task.populateJitData();
        } else {
            task.populateJitData(frameMemory);
        }
        DirectLongList data = task.getDataAddresses();
        DirectLongList varSizeAux = task.getAuxAddresses();
        DirectLongList rows = task.getFilteredRows();
        long hi = compiledFilter.call(data.getAddress(), data.size(), varSizeAux.getAddress(), bindVarMemory.getAddress(), bindVarFunctions.size(), rows.getAddress(), task.getFrameRowCount(), 0L);
        rows.setPos(hi);
    }

    public static void applyFilter(@NotNull Function filter, @NotNull DirectLongList rows, @NotNull PageFrameMemoryRecord record, long frameRowCount) {
        for (long r = 0L; r < frameRowCount; ++r) {
            record.setRowIndex(r);
            if (!filter.getBool(record)) continue;
            rows.add(r);
        }
    }
}

