/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;

public class SortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final SortedLightRecordCursor cursor;
    private final ListColumnFilter sortColumnFilter;

    public SortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator, ListColumnFilter sortColumnFilter) {
        super(metadata);
        LongTreeChain chain = new LongTreeChain(configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortLightValuePageSize(), configuration.getSqlSortLightValueMaxPages());
        this.base = base;
        this.cursor = new SortedLightRecordCursor(chain, comparator);
        this.sortColumnFilter = sortColumnFilter;
    }

    public static void addSortKeys(PlanSink sink, ListColumnFilter filter) {
        sink.attr("keys").val('[');
        filter.toPlan(sink);
        sink.val(']');
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return SortedRecordCursorFactory.getScanDirection(this.sortColumnFilter);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sort light");
        SortedLightRecordCursorFactory.addSortKeys(sink, this.sortColumnFilter);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }
}

