/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.Reopenable;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class LongChain
implements Closeable,
Mutable,
Reopenable {
    private static final long CHAIN_VALUE_SIZE = 12L;
    private static final long MAX_HEAP_SIZE_LIMIT = Integer.toUnsignedLong(-1) - 1L << 2;
    private final Cursor cursor = new Cursor();
    private final long initialHeapSize;
    private final long maxHeapSize;
    private long heapLimit;
    private long heapPos;
    private long heapSize;
    private long heapStart;

    public LongChain(long valuePageSize, int valueMaxPages) {
        this.heapSize = this.initialHeapSize = valuePageSize;
        this.heapStart = this.heapPos = Unsafe.malloc(this.heapSize, 19);
        this.heapLimit = this.heapStart + this.heapSize;
        this.maxHeapSize = Math.min(valuePageSize * (long)valueMaxPages, MAX_HEAP_SIZE_LIMIT);
    }

    @Override
    public void clear() {
        this.heapPos = this.heapStart;
    }

    @Override
    public void close() {
        if (this.heapStart != 0L) {
            this.heapStart = Unsafe.free(this.heapStart, this.heapSize, 19);
            this.heapPos = 0L;
            this.heapLimit = 0L;
            this.heapSize = 0L;
        }
    }

    public Cursor getCursor(int tailOffset) {
        this.cursor.of(tailOffset);
        return this.cursor;
    }

    public int put(long value, int parentOffset) {
        this.checkCapacity();
        long appendRawOffset = this.heapPos - this.heapStart;
        int appendOffset = LongChain.compressOffset(appendRawOffset);
        Unsafe.getUnsafe().putLong(this.heapPos, value);
        Unsafe.getUnsafe().putInt(this.heapPos + 8L, parentOffset);
        this.heapPos += 12L;
        return appendOffset;
    }

    @Override
    public void reopen() {
        if (this.heapStart == 0L) {
            this.heapSize = this.initialHeapSize;
            this.heapStart = this.heapPos = Unsafe.malloc(this.heapSize, 19);
            this.heapLimit = this.heapStart + this.heapSize;
        }
    }

    private static int compressOffset(long rawOffset) {
        return (int)(rawOffset >> 2);
    }

    private static long uncompressOffset(int offset) {
        return (long)offset << 2;
    }

    private void checkCapacity() {
        if (this.heapPos + 12L > this.heapLimit) {
            long newHeapSize = this.heapSize << 1;
            if (newHeapSize > this.maxHeapSize) {
                throw LimitOverflowException.instance().put("limit of ").put(this.maxHeapSize).put(" memory exceeded in LongChain");
            }
            long newHeapPos = Unsafe.realloc(this.heapStart, this.heapSize, newHeapSize, 19);
            this.heapSize = newHeapSize;
            long delta = newHeapPos - this.heapStart;
            this.heapPos += delta;
            this.heapStart = newHeapPos;
            this.heapLimit = newHeapPos + newHeapSize;
        }
    }

    public class Cursor {
        private int nextOffset;

        public boolean hasNext() {
            return this.nextOffset != -1;
        }

        public long next() {
            long rawOffset = LongChain.uncompressOffset(this.nextOffset);
            long value = Unsafe.getUnsafe().getLong(LongChain.this.heapStart + rawOffset);
            this.nextOffset = Unsafe.getUnsafe().getInt(LongChain.this.heapStart + rawOffset + 8L);
            return value;
        }

        void of(int startOffset) {
            this.nextOffset = startOffset;
        }
    }
}

