/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public class CountRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final GenericRecordMetadata DEFAULT_COUNT_METADATA = new GenericRecordMetadata();
    private final RecordCursorFactory base;
    private final CountRecordCursor cursor = new CountRecordCursor();

    public CountRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory base) {
        super(metadata);
        this.base = base;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Count");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    static {
        DEFAULT_COUNT_METADATA.add(new TableColumnMetadata("count", 6));
    }

    private static class CountRecordCursor
    implements NoRandomAccessRecordCursor {
        private final CountRecord countRecord = new CountRecord();
        private final RecordCursor.Counter counter = new RecordCursor.Counter();
        private RecordCursor baseCursor;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long count;
        private boolean hasNext = true;

        private CountRecordCursor() {
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (this.hasNext) {
                counter.add(1L);
                this.hasNext = false;
            }
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
        }

        @Override
        public Record getRecord() {
            return this.countRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                if (this.count == -1L) {
                    long size = this.baseCursor.size();
                    if (size > -1L) {
                        this.count = size;
                    } else {
                        this.baseCursor.calculateSize(this.circuitBreaker, this.counter);
                        this.count = this.counter.get();
                    }
                }
                this.hasNext = false;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.count;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.hasNext = true;
        }

        private void of(RecordCursor baseCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            this.baseCursor = baseCursor;
            this.circuitBreaker = circuitBreaker;
            this.count = -1L;
            this.hasNext = true;
            this.counter.clear();
        }

        private class CountRecord
        implements Record {
            private CountRecord() {
            }

            @Override
            public long getLong(int col) {
                return CountRecordCursor.this.count;
            }
        }
    }
}

