/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.SingleColumnType;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class RowNumberFunctionFactory
implements FunctionFactory {
    public static final String NAME = "row_number";
    private static final SingleColumnType LONG_COLUMN_TYPE = new SingleColumnType(6);
    private static final String SIGNATURE = "row_number()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isWindow() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        if (windowContext.isEmpty()) {
            throw SqlException.emptyWindowContext(position);
        }
        if (windowContext.getPartitionByRecord() != null) {
            Map map = MapFactory.createUnorderedMap(configuration, windowContext.getPartitionByKeyTypes(), LONG_COLUMN_TYPE);
            return new RowNumberFunction(map, windowContext.getPartitionByRecord(), windowContext.getPartitionBySink());
        }
        return new SequenceRowNumberFunction();
    }

    private static class RowNumberFunction
    extends LongFunction
    implements WindowFunction,
    Reopenable {
        private final Map map;
        private final VirtualRecord partitionByRecord;
        private final RecordSink partitionBySink;
        private int columnIndex;
        private long rowNumber;

        public RowNumberFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink) {
            this.map = map;
            this.partitionByRecord = partitionByRecord;
            this.partitionBySink = partitionBySink;
        }

        @Override
        public void close() {
            Misc.free(this.map);
            Misc.freeObjList(this.partitionByRecord.getFunctions());
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long x = value.isNew() ? 0L : value.getLong(0);
            this.rowNumber = x + 1L;
            value.putLong(0, this.rowNumber);
        }

        @Override
        public long getLong(Record rec) {
            return this.rowNumber;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            Function.init(this.partitionByRecord.getFunctions(), symbolTableSource, executionContext, null);
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.rowNumber);
        }

        @Override
        public void reopen() {
            this.rowNumber = 0L;
            this.map.reopen();
        }

        @Override
        public void reset() {
            this.map.close();
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RowNumberFunctionFactory.SIGNATURE);
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(')');
        }

        @Override
        public void toTop() {
            this.rowNumber = 0L;
            this.map.clear();
        }
    }

    private static class SequenceRowNumberFunction
    extends LongFunction
    implements WindowFunction,
    Reopenable {
        private int columnIndex;
        private long rowNumber = 0L;

        private SequenceRowNumberFunction() {
        }

        @Override
        public void computeNext(Record record) {
            ++this.rowNumber;
        }

        @Override
        public long getLong(Record rec) {
            return this.rowNumber;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.toTop();
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), ++this.rowNumber);
        }

        @Override
        public void reopen() {
            this.toTop();
        }

        @Override
        public void reset() {
            this.toTop();
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RowNumberFunctionFactory.SIGNATURE);
        }

        @Override
        public void toTop() {
            this.rowNumber = 0L;
        }
    }
}

