/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class StrPosVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "strpos(\u00d8\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function substrFunc = args.getQuick(1);
        if (substrFunc.isConstant()) {
            Utf8Sequence substr = substrFunc.getVarcharA(null);
            if (substr == null) {
                return IntConstant.NULL;
            }
            return new ConstFunc(args.getQuick(0), substr);
        }
        return new Func(args.getQuick(0), substrFunc);
    }

    private static class ConstFunc
    extends IntFunction
    implements UnaryFunction {
        private final Utf8Sequence substr;
        private final Function varcharFunc;

        public ConstFunc(Function varcharFunc, Utf8Sequence substr) {
            this.varcharFunc = varcharFunc;
            this.substr = substr;
        }

        @Override
        public Function getArg() {
            return this.varcharFunc;
        }

        @Override
        public int getInt(Record rec) {
            Utf8Sequence str = this.varcharFunc.getVarcharA(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            return Utf8s.strpos(str, this.substr);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("strpos(").val(this.varcharFunc).val(",'").val(this.substr).val("')");
        }
    }

    private static class Func
    extends IntFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function substrFunc;

        public Func(Function strFunc, Function substrFunc) {
            this.strFunc = strFunc;
            this.substrFunc = substrFunc;
        }

        @Override
        public int getInt(Record rec) {
            Utf8Sequence str = this.strFunc.getVarcharA(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            Utf8Sequence substr = this.substrFunc.getVarcharA(rec);
            if (substr == null) {
                return Integer.MIN_VALUE;
            }
            return Utf8s.strpos(str, substr);
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "strpos";
        }

        @Override
        public Function getRight() {
            return this.substrFunc;
        }
    }
}

