/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class MatchStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        int patternPosition = argPositions.getQuick(1);
        if (pattern.isConstant()) {
            Matcher matcher = RegexUtils.createMatcher(pattern, patternPosition);
            if (matcher == null) {
                return BooleanConstant.FALSE;
            }
            return new MatchStrConstPatternFunction(value, matcher);
        }
        if (pattern.isRuntimeConstant()) {
            return new MatchStrRuntimeConstPatternFunction(value, pattern, patternPosition);
        }
        throw SqlException.$(patternPosition, "not implemented: dynamic pattern would be very slow to execute");
    }

    static class MatchStrConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Matcher matcher;
        private final Function value;

        public MatchStrConstPatternFunction(Function value, @NotNull Matcher matcher) {
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStrA(rec);
            return cs != null && this.matcher.reset(cs).find();
        }

        @Override
        public boolean isConstant() {
            return UnaryFunction.super.isConstant();
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value).val(" ~ ").val(this.matcher.pattern().toString());
        }
    }

    static class MatchStrRuntimeConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function fun;
        private final Function pattern;
        private final int patternPosition;
        private Matcher matcher;

        public MatchStrRuntimeConstPatternFunction(Function fun, Function pattern, int patternPosition) {
            this.fun = fun;
            this.pattern = pattern;
            this.patternPosition = patternPosition;
        }

        @Override
        public Function getArg() {
            return this.fun;
        }

        @Override
        public boolean getBool(Record rec) {
            if (this.matcher != null) {
                CharSequence cs = this.getArg().getStrA(rec);
                return cs != null && this.matcher.reset(cs).find();
            }
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            this.matcher = RegexUtils.createMatcher(this.pattern, this.patternPosition);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.fun).val(" ~ ").val(this.pattern.toString());
        }
    }
}

