/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.EqSymStrFunctionFactory;
import io.questdb.griffin.engine.functions.regex.AbstractLikeStrFunctionFactory;
import io.questdb.griffin.engine.functions.regex.MatchSymbolFunctionFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractLikeSymbolFunctionFactory
extends AbstractLikeStrFunctionFactory {
    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        SymbolFunction value = (SymbolFunction)args.getQuick(0);
        Function pattern = args.getQuick(1);
        if (value.isSymbolTableStatic()) {
            if (pattern.isConstant()) {
                int len;
                CharSequence likeSeq = pattern.getStrA(null);
                if (likeSeq != null && (len = likeSeq.length()) > 0) {
                    if (AbstractLikeSymbolFunctionFactory.countChar(likeSeq, '_') == 0 && AbstractLikeSymbolFunctionFactory.countChar(likeSeq, '\\') == 0) {
                        int anyCount = AbstractLikeSymbolFunctionFactory.countChar(likeSeq, '%');
                        if (anyCount == 1) {
                            if (len == 1) {
                                EqSymStrFunctionFactory.NullCheckFunc notNullFunc = new EqSymStrFunctionFactory.NullCheckFunc(value);
                                notNullFunc.setNegated();
                                return notNullFunc;
                            }
                            if (likeSeq.charAt(0) == '%') {
                                String patternStr = likeSeq.subSequence(1, len).toString();
                                if (this.isCaseInsensitive()) {
                                    return new ConstIEndsWithStaticSymbolTableFunction(value, patternStr);
                                }
                                return new ConstEndsWithStaticSymbolTableFunction(value, patternStr);
                            }
                            if (likeSeq.charAt(len - 1) == '%') {
                                String patternStr = likeSeq.subSequence(0, len - 1).toString();
                                if (this.isCaseInsensitive()) {
                                    return new ConstIStartsWithStaticSymbolTableFunction(value, patternStr);
                                }
                                return new ConstStartsWithStaticSymbolTableFunction(value, patternStr);
                            }
                        } else if (anyCount == 2) {
                            if (len == 2) {
                                EqSymStrFunctionFactory.NullCheckFunc notNullFunc = new EqSymStrFunctionFactory.NullCheckFunc(value);
                                notNullFunc.setNegated();
                                return notNullFunc;
                            }
                            if (likeSeq.charAt(0) == '%' && likeSeq.charAt(len - 1) == '%') {
                                String patternStr = likeSeq.subSequence(1, len - 1).toString();
                                if (this.isCaseInsensitive()) {
                                    return new ConstIContainsStaticSymbolTableFunction(value, patternStr);
                                }
                                return new ConstContainsStaticSymbolTableFunction(value, patternStr);
                            }
                        }
                    }
                    String p = AbstractLikeSymbolFunctionFactory.escapeSpecialChars(likeSeq, null);
                    assert (p != null);
                    int flags = 32;
                    if (this.isCaseInsensitive()) {
                        flags |= 2;
                        p = p.toLowerCase();
                    }
                    return new ConstLikeStaticSymbolTableFunction(value, Pattern.compile(p, flags).matcher(""));
                }
                return BooleanConstant.FALSE;
            }
            if (pattern.isRuntimeConstant()) {
                return new BindLikeStaticSymbolTableFunction(value, pattern, this.isCaseInsensitive());
            }
            throw SqlException.$(argPositions.getQuick(1), "use constant or bind variable");
        }
        return super.newInstance(position, args, argPositions, configuration, sqlExecutionContext);
    }

    private static void extractSymbolKeys(SymbolFunction symbolFun, IntList symbolKeys, Matcher matcher) {
        StaticSymbolTable symbolTable = symbolFun.getStaticSymbolTable();
        assert (symbolTable != null);
        symbolKeys.clear();
        if (matcher != null) {
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!matcher.reset(symbolTable.valueOf(i)).matches()) continue;
                symbolKeys.add(i);
            }
        }
    }

    @Override
    protected abstract boolean isCaseInsensitive();

    private static class ConstIEndsWithStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstIEndsWithStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.endsWithLowerCase(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstIEndsWithStaticSymbolTableFunction) {
                ConstIEndsWithStaticSymbolTableFunction thatP = (ConstIEndsWithStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstEndsWithStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstEndsWithStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.endsWith(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstEndsWithStaticSymbolTableFunction) {
                ConstEndsWithStaticSymbolTableFunction thatP = (ConstEndsWithStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstIStartsWithStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstIStartsWithStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.startsWithLowerCase(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstIStartsWithStaticSymbolTableFunction) {
                ConstIStartsWithStaticSymbolTableFunction thatP = (ConstIStartsWithStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val(this.pattern);
            sink.val('%');
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstStartsWithStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstStartsWithStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.startsWith(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstStartsWithStaticSymbolTableFunction) {
                ConstStartsWithStaticSymbolTableFunction thatP = (ConstStartsWithStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val(this.pattern);
            sink.val('%');
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstIContainsStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstIContainsStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.containsLowerCase(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstIContainsStaticSymbolTableFunction) {
                ConstIContainsStaticSymbolTableFunction thatP = (ConstIContainsStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstContainsStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstContainsStaticSymbolTableFunction(SymbolFunction value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            StaticSymbolTable symbolTable = this.value.getStaticSymbolTable();
            assert (symbolTable != null);
            this.symbolKeys.clear();
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!Chars.contains(symbolTable.valueOf(i), this.pattern)) continue;
                this.symbolKeys.add(i);
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstContainsStaticSymbolTableFunction) {
                ConstContainsStaticSymbolTableFunction thatP = (ConstContainsStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class ConstLikeStaticSymbolTableFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Matcher matcher;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public ConstLikeStaticSymbolTableFunction(SymbolFunction value, Matcher matcher) {
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            AbstractLikeSymbolFunctionFactory.extractSymbolKeys(this.value, this.symbolKeys, this.matcher);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof ConstLikeStaticSymbolTableFunction) {
                ConstLikeStaticSymbolTableFunction thatP = (ConstLikeStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            UnaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ~ ");
            sink.val(this.matcher.pattern().toString());
            if ((this.matcher.pattern().flags() & 2) != 0) {
                sink.val(" [case-sensitive]");
            }
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class BindLikeStaticSymbolTableFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final boolean caseInsensitive;
        private final Function pattern;
        private final IntList symbolKeys = new IntList();
        private final SymbolFunction value;
        private String lastPattern = null;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public BindLikeStaticSymbolTableFunction(SymbolFunction value, Function pattern, boolean caseInsensitive) {
            this.value = value;
            this.pattern = pattern;
            this.caseInsensitive = caseInsensitive;
        }

        @Override
        public boolean getBool(Record rec) {
            return MatchSymbolFunctionFactory.symbolMatches(this.value, rec, this.symbolKeys);
        }

        @Override
        public Function getLeft() {
            return this.value;
        }

        @Override
        public Function getRight() {
            return this.pattern;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            CharSequence patternValue = this.pattern.getStrA(null);
            if (patternValue != null && patternValue.length() > 0) {
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(patternValue, this.lastPattern);
                if (p != null) {
                    int flags = 32;
                    if (this.caseInsensitive) {
                        flags |= 2;
                        p = p.toLowerCase();
                    }
                    Matcher matcher = Pattern.compile(p, flags).matcher("");
                    this.lastPattern = p;
                    AbstractLikeSymbolFunctionFactory.extractSymbolKeys(this.value, this.symbolKeys, matcher);
                }
            } else {
                this.lastPattern = null;
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.value.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof BindLikeStaticSymbolTableFunction) {
                BindLikeStaticSymbolTableFunction thatP = (BindLikeStaticSymbolTableFunction)that;
                thatP.symbolKeys.clear();
                thatP.symbolKeys.addAll(this.symbolKeys);
                this.stateShared = true;
                thatP.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ~ ");
            sink.val(this.pattern);
            if (!this.caseInsensitive) {
                sink.val(" [case-sensitive]");
            }
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }
}

