/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class AddLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(HH)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AddLong256Func(args.getQuick(0), args.getQuick(1));
    }

    private static class AddLong256Func
    extends Long256Function
    implements BinaryFunction {
        final Function left;
        final Long256Impl long256A = new Long256Impl();
        final Long256Impl long256B = new Long256Impl();
        final Function right;

        public AddLong256Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public void getLong256(Record rec, CharSink<?> sink) {
            Long256Impl v = (Long256Impl)this.getLong256A(rec);
            v.toSink(sink);
        }

        @Override
        public Long256 getLong256A(Record rec) {
            return Long256Impl.add(this.long256A, this.left.getLong256A(rec), this.right.getLong256A(rec));
        }

        @Override
        public Long256 getLong256B(Record rec) {
            return Long256Impl.add(this.long256B, this.left.getLong256B(rec), this.right.getLong256B(rec));
        }

        @Override
        public String getName() {
            return "+";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isOperator() {
            return true;
        }
    }
}

