/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.finance;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class LevelTwoPriceArrayFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "l2price(DD[]D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        try {
            assert (args.size() == 3) : "args.size() should be 3, but got " + args.size();
            for (int i = 1; i < 3; ++i) {
                if (ColumnType.decodeArrayDimensionality(args.getQuick(i).getType()) == 1) continue;
                throw SqlException.$(argPositions.getQuick(i), "not a one-dimensional array");
            }
            return new LevelTwoPriceArrayFunction(args.getQuick(0), args.getQuick(1), argPositions.getQuick(1), args.getQuick(2));
        }
        catch (Throwable e) {
            Misc.freeObjList(args);
            throw e;
        }
    }

    private static class LevelTwoPriceArrayFunction
    extends DoubleFunction
    implements TernaryFunction {
        private final Function pricesArg;
        private final Function sizesArg;
        private final int sizesArgPos;
        private final Function targetArg;

        public LevelTwoPriceArrayFunction(Function targetArg, Function sizesArg, int sizesArgPos, Function pricesArg) {
            this.targetArg = targetArg;
            this.pricesArg = pricesArg;
            this.sizesArgPos = sizesArgPos;
            this.sizesArg = sizesArg;
        }

        @Override
        public Function getCenter() {
            return this.sizesArg;
        }

        @Override
        public double getDouble(Record rec) {
            double t = this.targetArg.getDouble(rec);
            ArrayView pricesArr = this.pricesArg.getArray(rec);
            ArrayView sizesArr = this.sizesArg.getArray(rec);
            if (pricesArr.isNull() || sizesArr.isNull()) {
                return Double.NaN;
            }
            int len = pricesArr.getDimLen(0);
            if (sizesArr.getDimLen(0) != len) {
                throw CairoException.nonCritical().position(this.sizesArgPos).put("prices array length doesn't match sizes array length");
            }
            double ta = 0.0;
            double pa = 0.0;
            double rt = t;
            for (int i = 0; i < len; ++i) {
                double size = sizesArr.getDouble(i);
                double price = pricesArr.getDouble(i);
                if ((ta += size) >= t) {
                    if (i == 0) {
                        return price;
                    }
                    double pp = rt * price;
                    return (pa + pp) / t;
                }
                pa += size * price;
                rt -= size;
            }
            return Double.NaN;
        }

        @Override
        public Function getLeft() {
            return this.targetArg;
        }

        @Override
        public Function getRight() {
            return this.pricesArg;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("l2price(").val(this.targetArg).val(", ").val(this.pricesArg).val(", ").val(this.sizesArg).val(')');
        }
    }
}

