/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(XX)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (!a.isConstant() && b.isConstant()) {
            return EqIPv4FunctionFactory.createHalfConstantFunc(b, a);
        }
        if (a.isConstant() && !b.isConstant()) {
            return EqIPv4FunctionFactory.createHalfConstantFunc(a, b);
        }
        return new Func(a, b);
    }

    private static Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        int constValue = constFunc.getIPv4(null);
        if (constValue == 0) {
            return new NullCheckFunc(varFunc);
        }
        return new ConstCheckFunc(varFunc, constValue);
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getIPv4(rec) == this.right.getIPv4(rec));
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }
    }

    private static class NullCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getIPv4(rec) == 0);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(" is not null ");
            } else {
                sink.val(" is null");
            }
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final int constant;

        public ConstCheckFunc(Function arg, int constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getIPv4(rec) == this.constant);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=').val(this.constant).val('\'');
        }
    }
}

