/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;

public class LongConstant
extends LongFunction
implements ConstantFunction {
    public static final LongConstant NULL = new LongConstant(Long.MIN_VALUE);
    public static final LongConstant ONE = new LongConstant(1L);
    public static final LongConstant ZERO = new LongConstant(0L);
    private final long value;

    public LongConstant(long value) {
        this.value = value;
    }

    public static LongConstant newInstance(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value != Long.MIN_VALUE) {
            return new LongConstant(value);
        }
        return NULL;
    }

    @Override
    public long getLong(Record rec) {
        return this.value;
    }

    @Override
    public boolean isNullConstant() {
        return this.value == Long.MIN_VALUE;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.value).val('L');
    }
}

