/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.ObjList;

public class LongColumn
extends LongFunction
implements Function {
    private static final ObjList<LongColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    private LongColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static LongColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new LongColumn(columnIndex);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.columnIndex);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new LongColumn(i));
        }
    }
}

