/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CheckpointStatusFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "checkpoint_status()";
    private static final int inProgressColumn;
    private static final int startedAtColumn;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new CheckpointStatusCursorFactory()){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("in_progress", 1));
        inProgressColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("started_at", 8));
        startedAtColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class CheckpointStatusCursorFactory
    extends AbstractRecordCursorFactory {
        private final CheckpointStatusRecordCursor cursor = new CheckpointStatusRecordCursor();
        private CairoEngine engine;

        public CheckpointStatusCursorFactory() {
            super(METADATA);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.engine = executionContext.getCairoEngine();
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(CheckpointStatusFunctionFactory.SIGNATURE);
        }

        private class CheckpointStatusRecordCursor
        implements NoRandomAccessRecordCursor {
            private final CheckpointStatusRecord record = new CheckpointStatusRecord();
            private boolean rowPending = true;

            private CheckpointStatusRecordCursor() {
            }

            @Override
            public void close() {
                this.rowPending = true;
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                if (this.rowPending) {
                    long startedAt = CheckpointStatusCursorFactory.this.engine.getCheckpointStatus().startedAtTimestamp();
                    this.record.of(startedAt > -1L, startedAt);
                    this.rowPending = false;
                    return true;
                }
                return false;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public void toTop() {
                this.close();
            }

            public class CheckpointStatusRecord
            implements Record {
                private boolean inProgress;
                private long startedAt;

                @Override
                public boolean getBool(int col) {
                    if (col == inProgressColumn) {
                        return this.inProgress;
                    }
                    return false;
                }

                @Override
                public long getTimestamp(int col) {
                    if (col == startedAtColumn) {
                        return this.startedAt;
                    }
                    return Long.MIN_VALUE;
                }

                private void of(boolean inProgress, long startedAt) {
                    this.inProgress = inProgress;
                    this.startedAt = startedAt;
                }
            }
        }
    }
}

