/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToDoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8d)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToDoubleFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public double getDouble(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            try {
                return value == null ? Double.NaN : Numbers.parseDouble(value.asAsciiCharSequence());
            }
            catch (NumericException e) {
                return Double.NaN;
            }
        }
    }
}

