/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastFloatToShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Fe)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToShortFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public short getShort(Record rec) {
            float value = this.arg.getFloat(rec);
            return Numbers.isNull(value) || value > 32767.0f || value < -32768.0f ? (short)0 : (short)value;
        }
    }
}

