/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.SwarUtils;

public class CsvTextLexer
extends AbstractTextLexer {
    private static final long MASK_COMMA = SwarUtils.broadcast((byte)44);

    public CsvTextLexer(TextConfiguration textConfiguration) {
        super(textConfiguration);
    }

    @Override
    protected void doSwitch(long lo, long hi, byte b) throws AbstractTextLexer.LineLimitException {
        switch (b) {
            case 44: {
                this.onColumnDelimiter(lo);
                break;
            }
            case 34: {
                this.onQuote();
                break;
            }
            case 10: 
            case 13: {
                this.onLineEnd(hi);
                break;
            }
            default: {
                this.checkEol(lo);
            }
        }
    }

    @Override
    protected long getDelimiterMask() {
        return MASK_COMMA;
    }
}

