/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.cairo.security.ReadOnlySecurityContext;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;

public final class ReadOnlyUsersAwareSecurityContextFactory
implements SecurityContextFactory {
    private final boolean httpReadOnly;
    private final boolean pgWireReadOnly;
    private final String pgWireReadOnlyUser;
    private final boolean settingsReadOnly;

    public ReadOnlyUsersAwareSecurityContextFactory(boolean pgWireReadOnly, String pgWireReadOnlyUser, boolean httpReadOnly) {
        this(pgWireReadOnly, pgWireReadOnlyUser, httpReadOnly, false);
    }

    public ReadOnlyUsersAwareSecurityContextFactory(boolean pgWireReadOnly, String pgWireReadOnlyUser, boolean httpReadOnly, boolean settingsReadOnly) {
        this.pgWireReadOnly = pgWireReadOnly;
        this.pgWireReadOnlyUser = pgWireReadOnlyUser;
        this.httpReadOnly = httpReadOnly;
        this.settingsReadOnly = settingsReadOnly;
    }

    @Override
    public SecurityContext getInstance(CharSequence principal, ObjList<CharSequence> groups, byte authType, byte interfaceId) {
        switch (interfaceId) {
            case 0: {
                return this.httpReadOnly ? (this.settingsReadOnly ? ReadOnlySecurityContext.SETTINGS_READ_ONLY : ReadOnlySecurityContext.INSTANCE) : (this.settingsReadOnly ? AllowAllSecurityContext.SETTINGS_READ_ONLY : AllowAllSecurityContext.INSTANCE);
            }
            case 1: {
                return this.isReadOnlyPgWireUser(principal) ? ReadOnlySecurityContext.INSTANCE : AllowAllSecurityContext.INSTANCE;
            }
        }
        return AllowAllSecurityContext.INSTANCE;
    }

    private boolean isReadOnlyPgWireUser(CharSequence principal) {
        return this.pgWireReadOnly || this.pgWireReadOnlyUser != null && principal != null && Chars.equals((CharSequence)this.pgWireReadOnlyUser, principal);
    }
}

