/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cutlass.line.LineException;
import io.questdb.cutlass.line.udp.CachedCharSequence;
import io.questdb.cutlass.line.udp.CharSequenceCache;
import io.questdb.cutlass.line.udp.LineUdpParser;
import io.questdb.cutlass.line.udp.Utf8RepairContinue;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class LineUdpLexer
implements Mutable,
Closeable {
    protected final CharSequenceCache charSequenceCache;
    private final ArrayBackedCharSequence cs = new ArrayBackedCharSequence();
    private final FloatingCharSequence floatingCharSequence = new FloatingCharSequence();
    private final ArrayBackedUtf16Sink sink = new ArrayBackedUtf16Sink();
    private long buffer;
    private long bufferHi;
    private long dstPos = 0L;
    private long dstTop = 0L;
    private int errorCode = 0;
    private boolean escape = false;
    private boolean escapeQuote = false;
    private LineUdpParser parser;
    private boolean skipLine = false;
    private int state = 1;
    private boolean unquoted = true;
    private long utf8ErrorPos;
    private long utf8ErrorTop;

    public LineUdpLexer(int bufferSize) {
        this.buffer = Unsafe.malloc(bufferSize, 34);
        this.bufferHi = this.buffer + (long)bufferSize;
        this.charSequenceCache = address -> {
            this.floatingCharSequence.lo = this.buffer + (long)Numbers.decodeHighInt(address);
            this.floatingCharSequence.hi = this.buffer + (long)Numbers.decodeLowInt(address) - 2L;
            assert (this.floatingCharSequence.hi < this.bufferHi);
            assert (this.floatingCharSequence.lo >= this.buffer);
            assert (this.floatingCharSequence.lo <= this.floatingCharSequence.hi);
            return this.floatingCharSequence;
        };
        this.clear();
    }

    @Override
    public final void clear() {
        this.escape = false;
        this.escapeQuote = false;
        this.dstTop = this.dstPos = this.buffer;
        this.state = 1;
        this.utf8ErrorPos = -1L;
        this.utf8ErrorTop = -1L;
        this.skipLine = false;
        this.unquoted = true;
        this.errorCode = 0;
    }

    @Override
    public void close() {
        Unsafe.free(this.buffer, this.bufferHi - this.buffer, 34);
    }

    public void parse(long bytesPtr, long hi) {
        this.parsePartial(bytesPtr, hi);
    }

    public void parseLast() {
        if (!this.skipLine) {
            this.dstPos += 2L;
            try {
                this.onEol();
            }
            catch (LineException e) {
                this.parser.onError((int)(this.dstPos - 2L - this.buffer) / 2, this.state, this.errorCode);
            }
        }
        this.clear();
    }

    public void withParser(LineUdpParser parser) {
        this.parser = parser;
    }

    private void chop() {
        this.dstTop = this.dstPos;
    }

    private void doSkipLine(byte b) {
        if (b == 10 || b == 13) {
            this.clear();
            this.doSkipLineComplete();
        }
    }

    private void fireEvent() throws LineException {
        if (this.dstTop > this.dstPos - 3L && this.state != 3) {
            this.errorCode = 3;
            throw LineException.INSTANCE;
        }
        this.parser.onEvent(this.cs, this.state, this.charSequenceCache);
        this.chop();
    }

    private void fireEventTransition(int evtTagName, int evtFieldName) {
        switch (this.state) {
            case 1: 
            case 2: {
                this.fireEvent();
                this.state = evtTagName;
                break;
            }
            case 3: {
                this.fireEvent();
                this.state = evtFieldName;
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineException.INSTANCE;
            }
        }
    }

    private void fireEventTransition2() {
        switch (this.state) {
            case 4: {
                this.fireEvent();
                this.state = 2;
                break;
            }
            case 5: {
                this.fireEvent();
                this.state = 3;
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineException.INSTANCE;
            }
        }
    }

    private void onComma() {
        if (!this.escapeQuote && this.unquoted) {
            this.fireEventTransition(4, 5);
        }
        this.escapeQuote = false;
    }

    private void onEquals() {
        if (!this.escapeQuote && this.unquoted) {
            this.fireEventTransition2();
        }
        this.escapeQuote = false;
    }

    private void onEsc() {
        if (!this.unquoted) {
            this.escapeQuote = true;
        } else {
            this.escape = true;
        }
    }

    private void onQuote(byte lastByte) {
        if (lastByte == 61 && !this.escapeQuote && this.unquoted) {
            this.unquoted = false;
        } else if (!this.unquoted && !this.escapeQuote) {
            this.unquoted = true;
        }
        this.escapeQuote = false;
    }

    private void onSpace() {
        if (!this.escapeQuote && this.unquoted) {
            this.fireEventTransition(5, 6);
        }
        this.escapeQuote = false;
    }

    private long repairMultiByteChar(long lo, long hi, byte b) throws LineException {
        int n = -1;
        while (true) {
            if (this.utf8ErrorTop == -1L) {
                this.utf8ErrorTop = this.utf8ErrorPos = this.dstPos + 1L;
            }
            this.dstPos = this.utf8ErrorPos++;
            this.sink.put((char)b);
            long errorLen = this.utf8ErrorPos - this.utf8ErrorTop;
            if (errorLen > 1L) {
                this.dstPos = this.utf8ErrorTop - 1L;
                n = Utf8s.utf8DecodeMultiByte(this.utf8ErrorTop, this.utf8ErrorPos, Unsafe.getUnsafe().getByte(this.utf8ErrorTop), (Utf16Sink)this.sink);
            }
            if (n == -1 && errorLen > 3L) {
                this.errorCode = 2;
                throw LineException.INSTANCE;
            }
            if (n != -1 || ++lo >= hi) break;
            b = Unsafe.getUnsafe().getByte(lo);
        }
        this.dstPos = this.utf8ErrorTop - 1L;
        if (n > 0) {
            this.utf8ErrorPos = -1L;
            this.utf8ErrorTop = -1L;
            return lo + 1L;
        }
        throw Utf8RepairContinue.INSTANCE;
    }

    private long utf8Decode(long lo, long hi, byte b) throws LineException {
        if (this.utf8ErrorPos > -1L) {
            return this.repairMultiByteChar(lo, hi, b);
        }
        int n = Utf8s.utf8DecodeMultiByte(lo, hi, b, (Utf16Sink)this.sink);
        if (n == -1) {
            return this.repairMultiByteChar(lo, hi, b);
        }
        return lo + (long)n;
    }

    protected void doSkipLineComplete() {
    }

    protected void onEol() throws LineException {
        if (!this.escapeQuote) {
            switch (this.state) {
                case 1: {
                    this.chop();
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    this.fireEvent();
                    this.parser.onLineEnd(this.charSequenceCache);
                    this.clear();
                    break;
                }
                default: {
                    this.errorCode = 1;
                    throw LineException.INSTANCE;
                }
            }
        }
    }

    protected void parsePartial(long bytesPtr, long hi) {
        long p = bytesPtr;
        byte lastByte = 0;
        while (p < hi && !this.partialComplete()) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (this.skipLine) {
                this.doSkipLine(b);
                ++p;
                lastByte = 0;
                continue;
            }
            if (this.escape) {
                this.dstPos -= 2L;
            }
            try {
                if (b > -1) {
                    this.sink.put((char)b);
                    ++p;
                } else {
                    try {
                        p = this.utf8Decode(p, hi, b);
                    }
                    catch (Utf8RepairContinue e) {
                        break;
                    }
                }
                this.dstPos += 2L;
                if (this.escape) {
                    this.escape = false;
                    lastByte = b;
                    continue;
                }
                switch (b) {
                    case 34: {
                        this.onQuote(lastByte);
                        break;
                    }
                    case 92: {
                        this.onEsc();
                        break;
                    }
                    case 10: 
                    case 13: {
                        this.onEol();
                        break;
                    }
                    case 32: {
                        this.onSpace();
                        break;
                    }
                    case 44: {
                        this.onComma();
                        break;
                    }
                    case 61: {
                        this.onEquals();
                        break;
                    }
                    default: {
                        this.escapeQuote = false;
                    }
                }
                lastByte = b;
            }
            catch (LineException ex) {
                this.skipLine = true;
                this.parser.onError((int)(this.dstPos - 2L - this.buffer) / 2, this.state, this.errorCode);
            }
        }
    }

    protected boolean partialComplete() {
        return false;
    }

    private class ArrayBackedCharSequence
    extends AbstractCharSequence
    implements CachedCharSequence {
        private ArrayBackedCharSequence() {
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(LineUdpLexer.this.dstTop + (long)index * 2L);
        }

        @Override
        public long getCacheAddress() {
            return Numbers.encodeLowHighInts((int)(LineUdpLexer.this.dstPos - LineUdpLexer.this.buffer), (int)(LineUdpLexer.this.dstTop - LineUdpLexer.this.buffer));
        }

        @Override
        public int length() {
            return (int)((LineUdpLexer.this.dstPos - LineUdpLexer.this.dstTop) / 2L - 1L);
        }
    }

    private static class FloatingCharSequence
    extends AbstractCharSequence {
        long lo;
        long hi;

        private FloatingCharSequence() {
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(this.lo + (long)index * 2L);
        }

        @Override
        public int length() {
            return (int)(this.hi - this.lo) / 2;
        }

        @Override
        @NotNull
        protected CharSequence _subSequence(int start, int end) {
            FloatingCharSequence fcs = new FloatingCharSequence();
            fcs.lo = this.lo + (long)start * 2L;
            fcs.hi = this.lo + (long)end * 2L;
            return fcs;
        }
    }

    private class ArrayBackedUtf16Sink
    implements Utf16Sink {
        private ArrayBackedUtf16Sink() {
        }

        @Override
        public Utf16Sink put(char c) {
            if (LineUdpLexer.this.dstPos == LineUdpLexer.this.bufferHi) {
                this.extend();
            }
            Unsafe.getUnsafe().putChar(LineUdpLexer.this.dstPos, c);
            return this;
        }

        private void extend() {
            int capacity = (int)(LineUdpLexer.this.bufferHi - LineUdpLexer.this.buffer) * 2;
            if (capacity < 0) {
                throw LineException.INSTANCE;
            }
            long buf = Unsafe.realloc(LineUdpLexer.this.buffer, LineUdpLexer.this.bufferHi - LineUdpLexer.this.buffer, capacity, 34);
            long offset = LineUdpLexer.this.dstTop - LineUdpLexer.this.buffer;
            LineUdpLexer.this.bufferHi = buf + (long)capacity;
            LineUdpLexer.this.buffer = buf;
            LineUdpLexer.this.dstPos = buf + offset + (LineUdpLexer.this.dstPos - LineUdpLexer.this.dstTop);
            LineUdpLexer.this.dstTop = buf + offset;
        }
    }
}

