/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.HttpClientConfiguration;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.cutlass.http.client.HttpClientException;
import io.questdb.network.Kqueue;
import io.questdb.network.SocketFactory;
import io.questdb.std.Misc;

public class HttpClientOsx
extends HttpClient {
    private Kqueue kqueue;

    public HttpClientOsx(HttpClientConfiguration configuration, SocketFactory socketFactory) {
        super(configuration, socketFactory);
        this.kqueue = new Kqueue(configuration.getKQueueFacade(), configuration.getWaitQueueCapacity());
    }

    @Override
    public void close() {
        super.close();
        this.kqueue = Misc.free(this.kqueue);
    }

    @Override
    protected void ioWait(int timeout, int op) {
        this.kqueue.setWriteOffset(0);
        if (op == 1) {
            this.kqueue.readFD(this.socket.getFd(), 0);
        } else {
            this.kqueue.writeFD(this.socket.getFd(), 0);
        }
        if (this.kqueue.register(1) != 0) {
            throw new HttpClientException("could not register with kqueue [op=").put(op).put(", errno=").errno(this.nf.errno()).put(']');
        }
        this.dieWaiting(this.kqueue.poll(timeout));
    }

    @Override
    protected void setupIoWait() {
    }
}

