/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.ArrayWriteState;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.std.Mutable;
import io.questdb.std.str.CharSink;

public class HttpResponseArrayWriteState
implements ArrayWriteState,
Mutable {
    private ArrayView arrayView;
    private int opsAlreadyDone;
    private int opsSinceReset;
    private HttpChunkedResponse response;

    @Override
    public void clear() {
        this.opsSinceReset = 0;
        this.opsAlreadyDone = 0;
        this.arrayView = null;
    }

    public ArrayView getArrayView() {
        return this.arrayView;
    }

    @Override
    public boolean incAndSayIfNewOp() {
        ++this.opsSinceReset;
        return this.opsSinceReset > this.opsAlreadyDone;
    }

    public boolean isClear() {
        return this.arrayView == null;
    }

    public boolean isNothingWritten() {
        return this.opsAlreadyDone == 0;
    }

    public void of(HttpChunkedResponse response) {
        this.response = response;
    }

    @Override
    public void performedOp() {
        this.opsAlreadyDone = Math.max(this.opsAlreadyDone, this.opsSinceReset);
        this.response.bookmark();
    }

    @Override
    public void putCharIfNew(CharSink<?> sink, char symbol) {
        if (this.incAndSayIfNewOp()) {
            sink.put(symbol);
        }
        this.performedOp();
    }

    public void reset(ArrayView arrayView) {
        this.opsSinceReset = 0;
        this.arrayView = arrayView;
    }
}

