/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.AtomicIntList;
import io.questdb.std.BoolList;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

class WalEventWriter
implements Closeable {
    private final CairoConfiguration configuration;
    private final MemoryMARW eventIndexMem = Vm.getCMARWInstance();
    private final MemoryMARW eventMem = Vm.getCMARWInstance();
    private final FilesFacade ff;
    private final StringSink sink = new StringSink();
    private AtomicIntList initialSymbolCounts;
    private boolean legacyMatViewFormat;
    private long startOffset = 0L;
    private BoolList symbolMapNullFlags;
    private int txn = 0;
    private ObjList<CharSequenceIntHashMap> txnSymbolMaps;

    WalEventWriter(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
    }

    @Override
    public void close() {
        this.close(true, (byte)1);
    }

    public void close(boolean truncate, byte truncateMode) {
        this.eventMem.close(truncate, truncateMode);
        this.eventIndexMem.close(truncate, truncateMode);
    }

    public void setLegacyMatViewFormat(boolean legacyMatViewFormat) {
        this.legacyMatViewFormat = legacyMatViewFormat;
    }

    public long size() {
        return this.eventMem.getAppendOffset();
    }

    private void appendBindVariableValuesByIndex(BindVariableService bindVariableService) {
        int count = bindVariableService != null ? bindVariableService.getIndexedVariableCount() : 0;
        this.eventMem.putInt(count);
        for (int i = 0; i < count; ++i) {
            this.appendFunctionValue(bindVariableService.getFunction(i));
        }
    }

    private void appendBindVariableValuesByName(BindVariableService bindVariableService) {
        int count = bindVariableService != null ? bindVariableService.getNamedVariables().size() : 0;
        this.eventMem.putInt(count);
        if (count > 0) {
            ObjList<CharSequence> namedVariables = bindVariableService.getNamedVariables();
            for (int i = 0; i < count; ++i) {
                CharSequence name = namedVariables.get(i);
                this.eventMem.putStr(name);
                this.sink.clear();
                this.sink.put(':').put(name);
                this.appendFunctionValue(bindVariableService.getFunction(this.sink));
            }
        }
    }

    private void appendFunctionValue(Function function) {
        int type = function.getType();
        this.eventMem.putInt(type);
        switch (ColumnType.tagOf(type)) {
            case 1: {
                this.eventMem.putBool(function.getBool(null));
                break;
            }
            case 2: {
                this.eventMem.putByte(function.getByte(null));
                break;
            }
            case 14: {
                this.eventMem.putByte(function.getGeoByte(null));
                break;
            }
            case 3: {
                this.eventMem.putShort(function.getShort(null));
                break;
            }
            case 15: {
                this.eventMem.putShort(function.getGeoShort(null));
                break;
            }
            case 4: {
                this.eventMem.putChar(function.getChar(null));
                break;
            }
            case 5: {
                this.eventMem.putInt(function.getInt(null));
                break;
            }
            case 25: {
                this.eventMem.putInt(function.getIPv4(null));
                break;
            }
            case 16: {
                this.eventMem.putInt(function.getGeoInt(null));
                break;
            }
            case 9: {
                this.eventMem.putFloat(function.getFloat(null));
                break;
            }
            case 6: {
                this.eventMem.putLong(function.getLong(null));
                break;
            }
            case 17: {
                this.eventMem.putLong(function.getGeoLong(null));
                break;
            }
            case 7: {
                this.eventMem.putLong(function.getDate(null));
                break;
            }
            case 8: {
                this.eventMem.putLong(function.getTimestamp(null));
                break;
            }
            case 10: {
                this.eventMem.putDouble(function.getDouble(null));
                break;
            }
            case 11: {
                this.eventMem.putStr(function.getStrA(null));
                break;
            }
            case 26: {
                VarcharTypeDriver.appendPlainValue(this.eventMem, function.getVarcharA(null));
                break;
            }
            case 18: {
                this.eventMem.putBin(function.getBin(null));
                break;
            }
            case 19: {
                this.eventMem.putLong128(function.getLong128Lo(null), function.getLong128Hi(null));
                break;
            }
            case 27: {
                this.eventMem.putArray(function.getArray(null));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
            }
        }
    }

    private void appendIndex(long value) {
        this.eventIndexMem.putLong(value);
    }

    private void init() {
        this.eventMem.putInt(0);
        this.eventMem.putInt(0);
        this.eventMem.putInt(-1);
        this.appendIndex(8L);
        this.txn = 0;
    }

    private void writeSymbolMapDiffs() {
        int columns = this.txnSymbolMaps.size();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            int initialCount;
            CharSequenceIntHashMap symbolMap = this.txnSymbolMaps.getQuick(columnIndex);
            if (symbolMap == null || (initialCount = this.initialSymbolCounts.get(columnIndex)) <= 0 && (initialCount != 0 || symbolMap.size() <= 0)) continue;
            this.eventMem.putInt(columnIndex);
            this.eventMem.putBool(this.symbolMapNullFlags.get(columnIndex));
            this.eventMem.putInt(initialCount);
            int size = symbolMap.size();
            long appendAddress = this.eventMem.getAppendOffset();
            this.eventMem.putInt(size);
            int symbolCount = 0;
            for (int j = 0; j < size; ++j) {
                CharSequence symbol = symbolMap.keys().getQuick(j);
                assert (symbol != null);
                int value = symbolMap.get(symbol);
                if (value < initialCount) continue;
                this.eventMem.putInt(value);
                this.eventMem.putStr(symbol);
                ++symbolCount;
            }
            this.eventMem.putInt(appendAddress, symbolCount);
            this.eventMem.putInt(-1);
        }
        this.eventMem.putInt(-1);
    }

    int appendData(byte txnType, long startRowID, long endRowID, long minTimestamp, long maxTimestamp, boolean outOfOrder, long lastRefreshBaseTxn, long lastRefreshTimestamp, long lastPeriodHi, long replaceRangeLowTs, long replaceRangeHiTs, byte dedupMode) {
        assert (txnType == 3 || txnType == 0) : "unexpected txn type: " + txnType;
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte(txnType);
        this.eventMem.putLong(startRowID);
        this.eventMem.putLong(endRowID);
        this.eventMem.putLong(minTimestamp);
        this.eventMem.putLong(maxTimestamp);
        this.eventMem.putBool(outOfOrder);
        if (txnType == 3) {
            assert (lastRefreshBaseTxn != Long.MIN_VALUE);
            this.eventMem.putLong(lastRefreshBaseTxn);
            this.eventMem.putLong(lastRefreshTimestamp);
        }
        if (dedupMode == 3) {
            if (replaceRangeLowTs >= replaceRangeHiTs) {
                throw CairoException.nonCritical().put("Replace range low timestamp must be less than replace range high timestamp.");
            }
            if (replaceRangeLowTs > minTimestamp) {
                throw CairoException.nonCritical().put("Replace range low timestamp must be less than or equal to the minimum timestamp.");
            }
            if (replaceRangeHiTs <= maxTimestamp) {
                throw CairoException.nonCritical().put("Replace range high timestamp must be greater than the maximum timestamp.");
            }
        }
        this.writeSymbolMapDiffs();
        if (dedupMode != 0) {
            if (txnType == 3) {
                this.eventMem.putLong(lastPeriodHi);
            } else {
                this.eventMem.putLong(Long.MIN_VALUE);
            }
            this.eventMem.putLong(replaceRangeLowTs);
            this.eventMem.putLong(replaceRangeHiTs);
            this.eventMem.putByte(dedupMode);
        }
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.appendIndex(this.eventMem.getAppendOffset() - 4L);
        this.eventMem.putInt(0L, this.txn);
        if (txnType == 3) {
            this.eventMem.putInt(4L, 1);
        }
        return this.txn++;
    }

    int appendMatViewInvalidate(long lastRefreshBaseTxn, long lastRefreshTimestamp, boolean invalid, @Nullable CharSequence invalidationReason, long lastPeriodHi, @Nullable LongList refreshIntervals, long refreshIntervalsBaseTxn) {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)4);
        this.eventMem.putLong(lastRefreshBaseTxn);
        this.eventMem.putLong(lastRefreshTimestamp);
        this.eventMem.putBool(invalid);
        this.eventMem.putStr(invalidationReason);
        if (!this.legacyMatViewFormat) {
            this.eventMem.putLong(lastPeriodHi);
            this.eventMem.putLong(refreshIntervalsBaseTxn);
            if (refreshIntervals != null) {
                this.eventMem.putInt(refreshIntervals.size());
                int n = refreshIntervals.size();
                for (int i = 0; i < n; ++i) {
                    this.eventMem.putLong(refreshIntervals.getQuick(i));
                }
            } else {
                this.eventMem.putInt(-1);
            }
        }
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.appendIndex(this.eventMem.getAppendOffset() - 4L);
        this.eventMem.putInt(0L, this.txn);
        this.eventMem.putInt(4L, 1);
        return this.txn++;
    }

    int appendSql(int cmdType, CharSequence sqlText, SqlExecutionContext sqlExecutionContext) {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)1);
        this.eventMem.putInt(cmdType);
        this.eventMem.putStr(sqlText);
        Rnd rnd = sqlExecutionContext.getRandom();
        this.eventMem.putLong(rnd.getSeed0());
        this.eventMem.putLong(rnd.getSeed1());
        BindVariableService bindVariableService = sqlExecutionContext.getBindVariableService();
        this.appendBindVariableValuesByIndex(bindVariableService);
        this.appendBindVariableValuesByName(bindVariableService);
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.appendIndex(this.eventMem.getAppendOffset() - 4L);
        this.eventMem.putInt(0L, this.txn);
        return this.txn++;
    }

    void of(ObjList<CharSequenceIntHashMap> txnSymbolMaps, AtomicIntList initialSymbolCounts, BoolList symbolMapNullFlags) {
        this.txnSymbolMaps = txnSymbolMaps;
        this.initialSymbolCounts = initialSymbolCounts;
        this.symbolMapNullFlags = symbolMapNullFlags;
    }

    void openEventFile(Path path, int pathLen, boolean truncate, boolean systemTable) {
        if (this.eventMem.getFd() > -1L) {
            this.close(truncate, (byte)1);
        }
        long appendPageSize = systemTable ? this.configuration.getSystemWalEventAppendPageSize() : this.configuration.getWalEventAppendPageSize();
        this.eventMem.of(this.ff, path.trimTo(pathLen).concat("_event").$(), appendPageSize, -1L, 62, 0, Files.POSIX_MADV_RANDOM);
        this.eventIndexMem.of(this.ff, path.trimTo(pathLen).concat("_event.i").$(), Math.max(this.ff.getPageSize(), appendPageSize / 4L), -1L, 62, 0, Files.POSIX_MADV_SEQUENTIAL);
        this.init();
    }

    void rollback() {
        this.eventMem.putInt(this.startOffset, -1);
        this.eventMem.putInt(0L, --this.txn - 1);
    }

    void sync() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.eventMem.sync(commitMode == 0);
            this.eventIndexMem.sync(commitMode == 0);
        }
    }

    int truncate() {
        this.startOffset = this.eventMem.getAppendOffset() - 4L;
        this.eventMem.putLong(this.txn);
        this.eventMem.putByte((byte)2);
        this.eventMem.putInt(this.startOffset, (int)(this.eventMem.getAppendOffset() - this.startOffset));
        this.eventMem.putInt(-1);
        this.appendIndex(this.eventMem.getAppendOffset() - 4L);
        this.eventMem.putInt(0L, this.txn);
        return this.txn++;
    }
}

