/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class MemoryCMRDetachedImpl
extends MemoryCMRImpl {
    private static final Log LOG = LogFactory.getLog(MemoryCMRDetachedImpl.class);

    public MemoryCMRDetachedImpl(FilesFacade ff, LPSZ name, long size, int memoryTag, boolean keepFdOpen) {
        this.of(ff, name, 0L, size, memoryTag, 0, -1, keepFdOpen);
    }

    @Override
    public void extend(long newSize) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public long getFd() {
        throw new IllegalStateException("not supported");
    }

    @Override
    public boolean isOpen() {
        return this.pageAddress != 0L;
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, int opts, int madviseOpts) {
        this.of(ff, name, extendSegmentSize, size, memoryTag, opts, madviseOpts, false);
    }

    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, int opts, int madviseOpts, boolean keepFdOpen) {
        super.of(ff, name, extendSegmentSize, size, memoryTag, opts, madviseOpts);
        if (!keepFdOpen && ff != null && ff.close(this.fd)) {
            LOG.debug().$("closing [fd=").$(this.fd).I$();
            this.fd = -1L;
        }
    }

    public boolean tryChangeSize(long newSize) {
        if (newSize == this.size()) {
            return true;
        }
        if (newSize > 0L) {
            if (this.fd != -1L) {
                super.changeSize(newSize);
                return true;
            }
        } else {
            this.close();
            return true;
        }
        return false;
    }
}

