/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.security.ReadOnlySecurityContext;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MatViewRefreshSqlExecutionContext
extends SqlExecutionContextImpl {
    private TableReader baseTableReader;
    private TableToken viewTableToken;

    public MatViewRefreshSqlExecutionContext(CairoEngine engine, int sharedQueryWorkerCount) {
        super(engine, sharedQueryWorkerCount);
        if (!engine.getConfiguration().isMatViewParallelSqlEnabled()) {
            this.setParallelFilterEnabled(false);
            this.setParallelGroupByEnabled(false);
            this.setParallelTopKEnabled(false);
            this.setParallelReadParquetEnabled(false);
        }
        this.securityContext = new ReadOnlySecurityContext(){

            @Override
            public void authorizeInsert(TableToken tableToken) {
                if (!tableToken.equals(MatViewRefreshSqlExecutionContext.this.viewTableToken)) {
                    throw CairoException.authorization().put("Write permission denied").setCacheable(true);
                }
            }
        };
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
    }

    @Override
    public boolean allowNonDeterministicFunctions() {
        return false;
    }

    public void clearReader() {
        this.viewTableToken = null;
        this.baseTableReader = null;
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        return this.getSimpleCircuitBreaker();
    }

    @Override
    public TableReader getReader(TableToken tableToken, long version) {
        if (tableToken.equals(this.baseTableReader.getTableToken())) {
            if (version > -1L && this.baseTableReader.getMetadataVersion() != version) {
                int tableId = tableToken.getTableId();
                throw TableReferenceOutOfDateException.of(tableToken, tableId, tableId, version, this.baseTableReader.getMetadataVersion());
            }
            return this.getCairoEngine().getReaderAtTxn(this.baseTableReader);
        }
        return this.getCairoEngine().getReader(tableToken, version);
    }

    @Override
    public TableReader getReader(TableToken tableToken) {
        if (tableToken.equals(this.baseTableReader.getTableToken())) {
            return this.getCairoEngine().getReaderAtTxn(this.baseTableReader);
        }
        return this.getCairoEngine().getReader(tableToken);
    }

    @Override
    public boolean isOverriddenIntrinsics(TableToken tableToken) {
        return tableToken == this.baseTableReader.getTableToken();
    }

    public void of(TableReader baseTableReader) {
        this.viewTableToken = baseTableReader.getTableToken();
        this.baseTableReader = baseTableReader;
    }

    @Override
    public void overrideWhereIntrinsics(TableToken tableToken, IntrinsicModel intrinsicModel) {
        if (tableToken != this.baseTableReader.getTableToken()) {
            return;
        }
        intrinsicModel.setBetweenBoundary(new IndexedParameterLinkFunction(1, 8, 0));
        intrinsicModel.setBetweenBoundary(new IndexedParameterLinkFunction(2, 8, 0));
    }

    @Override
    public void setAllowNonDeterministicFunction(boolean value) {
    }

    public void setRange(long tsLo, long tsHi) throws SqlException {
        this.getBindVariableService().setTimestamp(1, tsLo);
        this.getBindVariableService().setTimestamp(2, tsHi - 1L);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        super.toSink(sink);
        sink.putAscii(", refreshMinTs=").putISODate(this.getTimestamp(1));
        sink.putAscii(", refreshMaxTs=").putISODate(this.getTimestamp(2));
    }

    private long getTimestamp(int index) {
        Function func = this.getBindVariableService().getFunction(index);
        if (func == null || func.getType() != 8) {
            return Long.MIN_VALUE;
        }
        return func.getTimestamp(null);
    }
}

