/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractPartitionFrameCursorFactory;
import io.questdb.cairo.IntervalBwdPartitionFrameCursor;
import io.questdb.cairo.IntervalFwdPartitionFrameCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.Misc;

public class IntervalPartitionFrameCursorFactory
extends AbstractPartitionFrameCursorFactory {
    private final int baseOrder;
    private final RuntimeIntrinsicIntervalModel intervalModel;
    private final int timestampIndex;
    private IntervalBwdPartitionFrameCursor bwdCursor;
    private IntervalFwdPartitionFrameCursor fwdCursor;

    public IntervalPartitionFrameCursorFactory(TableToken tableToken, long metadataVersion, RuntimeIntrinsicIntervalModel intervalModel, int timestampIndex, RecordMetadata metadata, int baseOrder) {
        super(tableToken, metadataVersion, metadata);
        this.timestampIndex = timestampIndex;
        this.intervalModel = intervalModel;
        this.baseOrder = baseOrder;
    }

    @Override
    public void close() {
        super.close();
        this.fwdCursor = Misc.free(this.fwdCursor);
        this.bwdCursor = Misc.free(this.bwdCursor);
        Misc.free(this.intervalModel);
    }

    @Override
    public PartitionFrameCursor getCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        TableReader reader = this.getReader(executionContext);
        try {
            if (order == 0 || (order == 2 || order < 0) && this.baseOrder != 1) {
                if (this.fwdCursor == null) {
                    this.fwdCursor = new IntervalFwdPartitionFrameCursor(this.intervalModel, this.timestampIndex);
                }
                return this.fwdCursor.of(reader, executionContext);
            }
            if (this.bwdCursor == null) {
                this.bwdCursor = new IntervalBwdPartitionFrameCursor(this.intervalModel, this.timestampIndex);
            }
            return this.bwdCursor.of(reader, executionContext);
        }
        catch (Throwable th) {
            Misc.free(reader);
            throw th;
        }
    }

    @Override
    public int getOrder() {
        return this.baseOrder;
    }

    @Override
    public boolean hasInterval() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order = sink.getOrder();
        if (order == 2 || order < 0) {
            order = this.baseOrder;
        }
        if (order == 1) {
            sink.type("Interval backward scan");
        } else {
            sink.type("Interval forward scan");
        }
        super.toPlan(sink);
        sink.attr("intervals").val(this.intervalModel);
    }
}

