/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class BuildInformationHolder
implements BuildInformation,
CharSequence {
    private static final String UNKNOWN = "unknown";
    private final String buildKey;
    private final String commitHash;
    private final String jdkVersion;
    private final String swName;
    private final String swVersion;

    public BuildInformationHolder() {
        this(BuildInformationHolder.class);
    }

    public BuildInformationHolder(Class<?> clazz) {
        String jdkVersion;
        String commitHash;
        String swName;
        String swVersion;
        try {
            Attributes manifestAttributes = BuildInformationHolder.getManifestAttributes(clazz);
            swVersion = BuildInformationHolder.getAttr(manifestAttributes, "Implementation-Version", "[DEVELOPMENT]");
            swName = BuildInformationHolder.getAttr(manifestAttributes, "Implementation-Title", UNKNOWN);
            commitHash = BuildInformationHolder.getAttr(manifestAttributes, "Build-Commit-Hash", UNKNOWN);
            jdkVersion = BuildInformationHolder.getAttr(manifestAttributes, "Build-Jdk", UNKNOWN);
        }
        catch (IOException e) {
            swVersion = UNKNOWN;
            swName = UNKNOWN;
            commitHash = UNKNOWN;
            jdkVersion = UNKNOWN;
        }
        this.swVersion = swVersion;
        this.swName = swName;
        this.commitHash = commitHash;
        this.jdkVersion = jdkVersion;
        this.buildKey = this.makeBuildKey(swVersion, commitHash, jdkVersion);
    }

    public BuildInformationHolder(String swVersion, String commitHash, String jdkVersion, String swName) {
        this.swVersion = swVersion;
        this.commitHash = commitHash;
        this.jdkVersion = jdkVersion;
        this.swName = swName;
        this.buildKey = this.makeBuildKey(swVersion, commitHash, jdkVersion);
    }

    @Override
    public char charAt(int index) {
        return this.buildKey.charAt(index);
    }

    @Override
    public String getCommitHash() {
        return this.commitHash;
    }

    @Override
    public String getJdkVersion() {
        return this.jdkVersion;
    }

    @Override
    public String getSwName() {
        return this.swName;
    }

    @Override
    public String getSwVersion() {
        return this.swVersion;
    }

    @Override
    public int length() {
        return this.buildKey.length();
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.buildKey.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.buildKey;
    }

    private static String getAttr(Attributes manifestAttributes, String attributeName, String defaultValue) {
        String value = manifestAttributes.getValue(attributeName);
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getManifestAttributes(Class<?> clazz) throws IOException {
        InputStream is = clazz.getResourceAsStream("/META-INF/MANIFEST.MF");
        if (is != null) {
            try {
                Attributes attributes = new Manifest(is).getMainAttributes();
                String vendor = attributes.getValue("Implementation-Vendor-Id");
                if (vendor != null && vendor.contains("questdb")) {
                    Attributes attributes2 = attributes;
                    return attributes2;
                }
            }
            finally {
                is.close();
            }
        }
        return new Attributes();
    }

    private String makeBuildKey(CharSequence swVersion, CharSequence commitHash, CharSequence jdkVersion) {
        return String.valueOf(swVersion) + ":" + String.valueOf(commitHash) + ":" + String.valueOf(jdkVersion);
    }
}

