/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetPartsAllocResp
implements TBase,
Serializable,
Cloneable,
Comparable<GetPartsAllocResp> {
    private static final TStruct STRUCT_DESC = new TStruct("GetPartsAllocResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField PARTS_FIELD_DESC = new TField("parts", 13, 3);
    private static final TField TERMS_FIELD_DESC = new TField("terms", 13, 4);
    public ErrorCode code;
    public HostAddr leader;
    public Map<Integer, List<HostAddr>> parts;
    public Map<Integer, Long> terms;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int PARTS = 3;
    public static final int TERMS = 4;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public GetPartsAllocResp() {
    }

    public GetPartsAllocResp(ErrorCode code, HostAddr leader, Map<Integer, List<HostAddr>> parts) {
        this();
        this.code = code;
        this.leader = leader;
        this.parts = parts;
    }

    public GetPartsAllocResp(ErrorCode code, HostAddr leader, Map<Integer, List<HostAddr>> parts, Map<Integer, Long> terms) {
        this();
        this.code = code;
        this.leader = leader;
        this.parts = parts;
        this.terms = terms;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetPartsAllocResp(GetPartsAllocResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetParts()) {
            this.parts = TBaseHelper.deepCopy(other.parts);
        }
        if (other.isSetTerms()) {
            this.terms = TBaseHelper.deepCopy(other.terms);
        }
    }

    @Override
    public GetPartsAllocResp deepCopy() {
        return new GetPartsAllocResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public GetPartsAllocResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public GetPartsAllocResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<Integer, List<HostAddr>> getParts() {
        return this.parts;
    }

    public GetPartsAllocResp setParts(Map<Integer, List<HostAddr>> parts) {
        this.parts = parts;
        return this;
    }

    public void unsetParts() {
        this.parts = null;
    }

    public boolean isSetParts() {
        return this.parts != null;
    }

    public void setPartsIsSet(boolean __value) {
        if (!__value) {
            this.parts = null;
        }
    }

    public Map<Integer, Long> getTerms() {
        return this.terms;
    }

    public GetPartsAllocResp setTerms(Map<Integer, Long> terms) {
        this.terms = terms;
        return this;
    }

    public void unsetTerms() {
        this.terms = null;
    }

    public boolean isSetTerms() {
        return this.terms != null;
    }

    public void setTermsIsSet(boolean __value) {
        if (!__value) {
            this.terms = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetParts();
                    break;
                }
                this.setParts((Map)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetTerms();
                    break;
                }
                this.setTerms((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getParts();
            }
            case 4: {
                return this.getTerms();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof GetPartsAllocResp)) {
            return false;
        }
        GetPartsAllocResp that = (GetPartsAllocResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetParts(), that.isSetParts(), this.parts, that.parts)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetTerms(), that.isSetTerms(), this.terms, that.terms);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.parts, this.terms});
    }

    @Override
    public int compareTo(GetPartsAllocResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParts()).compareTo(other.isSetParts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.parts, other.parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTerms()).compareTo(other.isSetTerms());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.terms, other.terms);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map126 = iprot.readMapBegin();
                        this.parts = new HashMap<Integer, List<HostAddr>>(Math.max(0, 2 * _map126.size));
                        int _i127 = 0;
                        while (_map126.size < 0 ? iprot.peekMap() : _i127 < _map126.size) {
                            int _key128 = iprot.readI32();
                            TList _list130 = iprot.readListBegin();
                            ArrayList<HostAddr> _val129 = new ArrayList<HostAddr>(Math.max(0, _list130.size));
                            int _i131 = 0;
                            while (_list130.size < 0 ? iprot.peekList() : _i131 < _list130.size) {
                                HostAddr _elem132 = new HostAddr();
                                _elem132.read(iprot);
                                _val129.add(_elem132);
                                ++_i131;
                            }
                            iprot.readListEnd();
                            this.parts.put(_key128, _val129);
                            ++_i127;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 13) {
                        TMap _map133 = iprot.readMapBegin();
                        this.terms = new HashMap<Integer, Long>(Math.max(0, 2 * _map133.size));
                        int _i134 = 0;
                        while (_map133.size < 0 ? iprot.peekMap() : _i134 < _map133.size) {
                            int _key135 = iprot.readI32();
                            long _val136 = iprot.readI64();
                            this.terms.put(_key135, _val136);
                            ++_i134;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.parts != null) {
            oprot.writeFieldBegin(PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.parts.size()));
            for (Map.Entry<Integer, List<HostAddr>> entry : this.parts.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeListBegin(new TList(12, entry.getValue().size()));
                for (HostAddr _iter138 : entry.getValue()) {
                    _iter138.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.terms != null && this.isSetTerms()) {
            oprot.writeFieldBegin(TERMS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 10, this.terms.size()));
            for (Map.Entry<Integer, Object> entry : this.terms.entrySet()) {
                oprot.writeI32(entry.getKey());
                oprot.writeI64((Long)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("GetPartsAllocResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getParts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getParts(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetTerms()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("terms");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getTerms() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getTerms(), indent + 1, prettyPrint));
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("parts", 3, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, HostAddr.class)))));
        tmpMetaDataMap.put(4, new FieldMetaData("terms", 2, new MapMetaData(13, new FieldValueMetaData(8), new FieldValueMetaData(10))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(GetPartsAllocResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<Integer, List<HostAddr>> parts;
        private Map<Integer, Long> terms;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setParts(Map<Integer, List<HostAddr>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder setTerms(Map<Integer, Long> terms) {
            this.terms = terms;
            return this;
        }

        public GetPartsAllocResp build() {
            GetPartsAllocResp result = new GetPartsAllocResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setParts(this.parts);
            result.setTerms(this.terms);
            return result;
        }
    }
}

