/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.metrics;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.metrics.CommandLatencyId;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerOptions;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.local.LocalAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class MicrometerCommandLatencyRecorder
implements CommandLatencyRecorder {
    static final String LABEL_COMMAND = "command";
    static final String LABEL_LOCAL = "local";
    static final String LABEL_REMOTE = "remote";
    static final String METRIC_COMPLETION = "lettuce.command.completion";
    static final String METRIC_FIRST_RESPONSE = "lettuce.command.firstresponse";
    private final MeterRegistry meterRegistry;
    private final MicrometerOptions options;
    private final Map<CommandLatencyId, Timer> completionTimers = new ConcurrentHashMap<CommandLatencyId, Timer>();
    private final Map<CommandLatencyId, Timer> firstResponseTimers = new ConcurrentHashMap<CommandLatencyId, Timer>();

    public MicrometerCommandLatencyRecorder(MeterRegistry meterRegistry, MicrometerOptions options) {
        LettuceAssert.notNull((Object)meterRegistry, "MeterRegistry must not be null");
        LettuceAssert.notNull((Object)options, "MicrometerOptions must not be null");
        this.meterRegistry = meterRegistry;
        this.options = options;
    }

    @Override
    public void recordCommandLatency(SocketAddress local, SocketAddress remote, RedisCommand<?, ?, ?> redisCommand, long firstResponseLatency, long completionLatency) {
        if (this.isEnabled() && this.isCommandEnabled(redisCommand)) {
            this.recordCommandLatency(local, remote, redisCommand.getType(), firstResponseLatency, completionLatency);
        }
    }

    @Override
    public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType, long firstResponseLatency, long completionLatency) {
        if (!this.isEnabled()) {
            return;
        }
        CommandLatencyId commandLatencyId = this.createId(local, remote, commandType);
        Timer firstResponseTimer = this.firstResponseTimers.computeIfAbsent(commandLatencyId, this::firstResponseTimer);
        firstResponseTimer.record(firstResponseLatency, TimeUnit.NANOSECONDS);
        Timer completionTimer = this.completionTimers.computeIfAbsent(commandLatencyId, this::completionTimer);
        completionTimer.record(completionLatency, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isEnabled() {
        return this.options.isEnabled();
    }

    private boolean isCommandEnabled(RedisCommand<?, ?, ?> redisCommand) {
        return this.options.getMetricsFilter().test(redisCommand);
    }

    private CommandLatencyId createId(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType) {
        return CommandLatencyId.create(this.options.localDistinction() ? local : LocalAddress.ANY, remote, commandType);
    }

    protected Timer completionTimer(CommandLatencyId commandLatencyId) {
        Timer.Builder timer = Timer.builder((String)METRIC_COMPLETION).description("Latency between command send and command completion (complete response received").tag(LABEL_COMMAND, commandLatencyId.commandType().name()).tag(LABEL_LOCAL, commandLatencyId.localAddress().toString()).tag(LABEL_REMOTE, commandLatencyId.remoteAddress().toString()).tags((Iterable)this.options.tags());
        if (this.options.isHistogram()) {
            timer.publishPercentileHistogram().publishPercentiles(this.options.targetPercentiles()).minimumExpectedValue(this.options.minLatency()).maximumExpectedValue(this.options.maxLatency());
        }
        return timer.register(this.meterRegistry);
    }

    protected Timer firstResponseTimer(CommandLatencyId commandLatencyId) {
        Timer.Builder timer = Timer.builder((String)METRIC_FIRST_RESPONSE).description("Latency between command send and first response (first response received)").tag(LABEL_COMMAND, commandLatencyId.commandType().name()).tag(LABEL_LOCAL, commandLatencyId.localAddress().toString()).tag(LABEL_REMOTE, commandLatencyId.remoteAddress().toString()).tags((Iterable)this.options.tags());
        if (this.options.isHistogram()) {
            timer.publishPercentileHistogram().publishPercentiles(this.options.targetPercentiles()).minimumExpectedValue(this.options.minLatency()).maximumExpectedValue(this.options.maxLatency());
        }
        return timer.register(this.meterRegistry);
    }
}

