/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Objects;
import org.apache.hertzbeat.alert.service.AlertInhibitService;
import org.apache.hertzbeat.common.entity.alerter.AlertInhibit;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Inhibit API")
@RestController
@RequestMapping(path={"/api/alert/inhibit"}, produces={"application/json"})
public class AlertInhibitController {
    @Autowired
    private AlertInhibitService alertInhibitService;

    @PostMapping
    @Operation(summary="New Alarm Inhibit", description="Added an alarm Inhibit")
    public ResponseEntity<Message<Void>> addNewAlertInhibit(@Valid @RequestBody AlertInhibit alertInhibit) {
        this.alertInhibitService.validate(alertInhibit, false);
        this.alertInhibitService.addAlertInhibit(alertInhibit);
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modifying an Alarm Inhibit", description="Modify an existing alarm Inhibit")
    public ResponseEntity<Message<Void>> modifyAlertInhibit(@Valid @RequestBody AlertInhibit alertInhibit) {
        this.alertInhibitService.validate(alertInhibit, true);
        this.alertInhibitService.modifyAlertInhibit(alertInhibit);
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Querying Alarm Inhibit", description="You can obtain alarm Inhibit information based on the alarm Inhibit ID")
    public ResponseEntity<Message<AlertInhibit>> getAlertInhibit(@Parameter(description="Alarm Inhibit ID", example="6565463543") @PathVariable(value="id") long id) {
        AlertInhibit alertInhibit = this.alertInhibitService.getAlertInhibit(id);
        return Objects.isNull(alertInhibit) ? ResponseEntity.ok((Object)Message.fail((byte)3, (String)"AlertInhibit not exist.")) : ResponseEntity.ok((Object)Message.success((Object)alertInhibit));
    }
}

