/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.executors;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.executors.UncheckedTimeoutException;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.limit.AIMDLimit;
import com.netflix.concurrency.limits.limiter.BlockingLimiter;
import com.netflix.concurrency.limits.limiter.SimpleLimiter;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class BlockingAdaptiveExecutor
implements Executor {
    private final Limiter<Void> limiter;
    private final Executor executor;

    public static Builder newBuilder() {
        return new Builder();
    }

    private BlockingAdaptiveExecutor(Builder builder) {
        this.limiter = builder.limiter;
        this.executor = builder.executor;
    }

    @Deprecated
    public BlockingAdaptiveExecutor(Limiter<Void> limiter) {
        this(limiter, Executors.newCachedThreadPool());
    }

    @Deprecated
    public BlockingAdaptiveExecutor(Limiter<Void> limiter, Executor executor) {
        this.limiter = BlockingLimiter.wrap(limiter);
        this.executor = executor;
    }

    @Override
    public void execute(Runnable command) {
        Limiter.Listener listener = this.limiter.acquire(null).orElseThrow(() -> new RejectedExecutionException());
        try {
            this.executor.execute(() -> {
                try {
                    command.run();
                    listener.onSuccess();
                }
                catch (UncheckedTimeoutException e) {
                    listener.onDropped();
                }
                catch (RejectedExecutionException e) {
                    listener.onDropped();
                }
                catch (Exception e) {
                    listener.onIgnore();
                }
            });
        }
        catch (Exception e) {
            listener.onIgnore();
            throw e;
        }
    }

    public static class Builder {
        private static AtomicInteger idCounter = new AtomicInteger();
        private MetricRegistry metricRegistry = EmptyMetricRegistry.INSTANCE;
        private Executor executor;
        private Limiter<Void> limiter;
        private String name;

        public Builder metricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder limiter(Limiter<Void> limiter) {
            this.limiter = limiter;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public BlockingAdaptiveExecutor build() {
            if (this.name == null) {
                this.name = "unnamed-" + idCounter.incrementAndGet();
            }
            if (this.executor == null) {
                this.executor = Executors.newCachedThreadPool(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
            if (this.limiter == null) {
                this.limiter = ((SimpleLimiter.Builder)((SimpleLimiter.Builder)SimpleLimiter.newBuilder().metricRegistry(this.metricRegistry)).limit(AIMDLimit.newBuilder().build())).build();
            }
            return new BlockingAdaptiveExecutor(this);
        }
    }
}

