/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_17.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.ContextDataAccessor;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;

public final class LogEventMapper<T> {
    private static final AttributeKey<String> CODE_FILEPATH = AttributeKey.stringKey((String)"code.filepath");
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey((String)"code.function");
    private static final AttributeKey<Long> CODE_LINENO = AttributeKey.longKey((String)"code.lineno");
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey((String)"code.namespace");
    private static final AttributeKey<Long> THREAD_ID = AttributeKey.longKey((String)"thread.id");
    private static final AttributeKey<String> THREAD_NAME = AttributeKey.stringKey((String)"thread.name");
    private static final String SPECIAL_MAP_MESSAGE_ATTRIBUTE = "message";
    private static final Cache<String, AttributeKey<String>> contextDataAttributeKeyCache = Cache.bounded((int)100);
    private static final Cache<String, AttributeKey<String>> mapMessageAttributeKeyCache = Cache.bounded((int)100);
    private static final AttributeKey<String> LOG_MARKER = AttributeKey.stringKey((String)"log4j.marker");
    private final ContextDataAccessor<T> contextDataAccessor;
    private final boolean captureExperimentalAttributes;
    private final boolean captureCodeAttributes;
    private final boolean captureMapMessageAttributes;
    private final boolean captureMarkerAttribute;
    private final List<String> captureContextDataAttributes;
    private final boolean captureAllContextDataAttributes;

    public LogEventMapper(ContextDataAccessor<T> contextDataAccessor, boolean captureExperimentalAttributes, boolean captureCodeAttributes, boolean captureMapMessageAttributes, boolean captureMarkerAttribute, List<String> captureContextDataAttributes) {
        this.contextDataAccessor = contextDataAccessor;
        this.captureCodeAttributes = captureCodeAttributes;
        this.captureExperimentalAttributes = captureExperimentalAttributes;
        this.captureMapMessageAttributes = captureMapMessageAttributes;
        this.captureMarkerAttribute = captureMarkerAttribute;
        this.captureContextDataAttributes = captureContextDataAttributes;
        this.captureAllContextDataAttributes = captureContextDataAttributes.size() == 1 && captureContextDataAttributes.get(0).equals("*");
    }

    public void mapLogEvent(LogRecordBuilder builder, Message message, Level level, @Nullable Marker marker, @Nullable Throwable throwable, T contextData, String threadName, long threadId, Supplier<StackTraceElement> sourceSupplier, Context context) {
        StackTraceElement source;
        AttributesBuilder attributes = Attributes.builder();
        this.captureMessage(builder, attributes, message);
        if (this.captureMarkerAttribute && marker != null) {
            String markerName = marker.getName();
            attributes.put(LOG_MARKER, (Object)markerName);
        }
        if (level != null) {
            builder.setSeverity(LogEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.name());
        }
        if (throwable != null) {
            LogEventMapper.setThrowable(attributes, throwable);
        }
        this.captureContextDataAttributes(attributes, contextData);
        if (this.captureExperimentalAttributes) {
            attributes.put(THREAD_NAME, (Object)threadName);
            attributes.put(THREAD_ID, (Object)threadId);
        }
        if (this.captureCodeAttributes && (source = sourceSupplier.get()) != null) {
            String fileName = source.getFileName();
            if (fileName != null) {
                attributes.put(CODE_FILEPATH, (Object)fileName);
            }
            attributes.put(CODE_NAMESPACE, (Object)source.getClassName());
            attributes.put(CODE_FUNCTION, (Object)source.getMethodName());
            int lineNumber = source.getLineNumber();
            if (lineNumber > 0) {
                attributes.put(CODE_LINENO, lineNumber);
            }
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(context);
    }

    void captureMessage(LogRecordBuilder builder, AttributesBuilder attributes, Message message) {
        boolean checkSpecialMapMessageAttribute;
        if (message == null) {
            return;
        }
        if (!(message instanceof MapMessage)) {
            builder.setBody(message.getFormattedMessage());
            return;
        }
        MapMessage mapMessage = (MapMessage)message;
        String body = mapMessage.getFormat();
        boolean bl = checkSpecialMapMessageAttribute = body == null || body.isEmpty();
        if (checkSpecialMapMessageAttribute) {
            body = mapMessage.get(SPECIAL_MAP_MESSAGE_ATTRIBUTE);
        }
        if (body != null && !body.isEmpty()) {
            builder.setBody(body);
        }
        if (this.captureMapMessageAttributes) {
            mapMessage.getData().forEach((key, value) -> {
                if (!(value == null || checkSpecialMapMessageAttribute && key.equals(SPECIAL_MAP_MESSAGE_ATTRIBUTE))) {
                    attributes.put(LogEventMapper.getMapMessageAttributeKey(key), (Object)value.toString());
                }
            });
        }
    }

    void captureContextDataAttributes(AttributesBuilder attributes, T contextData) {
        if (this.captureAllContextDataAttributes) {
            this.contextDataAccessor.forEach(contextData, (key, value) -> {
                if (value != null) {
                    attributes.put(LogEventMapper.getContextDataAttributeKey(key), value);
                }
            });
            return;
        }
        for (String key2 : this.captureContextDataAttributes) {
            String value2 = this.contextDataAccessor.getValue(contextData, key2);
            if (value2 == null) continue;
            attributes.put(LogEventMapper.getContextDataAttributeKey(key2), (Object)value2);
        }
    }

    public static AttributeKey<String> getContextDataAttributeKey(String key) {
        return (AttributeKey)contextDataAttributeKeyCache.computeIfAbsent((Object)key, AttributeKey::stringKey);
    }

    public static AttributeKey<String> getMapMessageAttributeKey(String key) {
        return (AttributeKey)mapMessageAttributeKeyCache.computeIfAbsent((Object)key, k -> AttributeKey.stringKey((String)("log4j.map_message." + k)));
    }

    private static void setThrowable(AttributesBuilder attributes, Throwable throwable) {
        attributes.put(ExceptionAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
        attributes.put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
    }

    private static Severity levelToSeverity(Level level) {
        switch (level.getStandardLevel()) {
            case ALL: 
            case TRACE: {
                return Severity.TRACE;
            }
            case DEBUG: {
                return Severity.DEBUG;
            }
            case INFO: {
                return Severity.INFO;
            }
            case WARN: {
                return Severity.WARN;
            }
            case ERROR: {
                return Severity.ERROR;
            }
            case FATAL: {
                return Severity.FATAL;
            }
            case OFF: {
                return Severity.UNDEFINED_SEVERITY_NUMBER;
            }
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }
}

