/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Predicate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.manager.StatusPageComponent;
import org.apache.hertzbeat.common.entity.manager.StatusPageHistory;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncident;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.manager.component.status.CalculateStatus;
import org.apache.hertzbeat.manager.dao.StatusPageComponentDao;
import org.apache.hertzbeat.manager.dao.StatusPageHistoryDao;
import org.apache.hertzbeat.manager.dao.StatusPageIncidentComponentBindDao;
import org.apache.hertzbeat.manager.dao.StatusPageIncidentDao;
import org.apache.hertzbeat.manager.dao.StatusPageOrgDao;
import org.apache.hertzbeat.manager.pojo.dto.ComponentStatus;
import org.apache.hertzbeat.manager.service.StatusPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StatusPageServiceImpl
implements StatusPageService {
    private static final int HISTORY_SPAN_DAYS = 29;
    @Autowired
    private StatusPageOrgDao statusPageOrgDao;
    @Autowired
    private StatusPageComponentDao statusPageComponentDao;
    @Autowired
    private StatusPageHistoryDao statusPageHistoryDao;
    @Autowired
    private StatusPageIncidentDao statusPageIncidentDao;
    @Autowired
    private CalculateStatus calculateStatus;
    private final StatusPageIncidentComponentBindDao statusPageIncidentComponentBindDao;

    @Override
    public StatusPageOrg queryStatusPageOrg() {
        return this.statusPageOrgDao.findAll().stream().findFirst().orElse(null);
    }

    @Override
    public StatusPageOrg saveStatusPageOrg(StatusPageOrg statusPageOrg) {
        return this.statusPageOrgDao.save(statusPageOrg);
    }

    @Override
    public List<StatusPageComponent> queryStatusPageComponents() {
        return this.statusPageComponentDao.findAll();
    }

    @Override
    public void newStatusPageComponent(StatusPageComponent statusPageComponent) {
        if (statusPageComponent.getMethod() == 1) {
            statusPageComponent.setState(statusPageComponent.getConfigState());
        }
        this.statusPageComponentDao.save(statusPageComponent);
    }

    @Override
    public void updateStatusPageComponent(StatusPageComponent statusPageComponent) {
        if (statusPageComponent.getMethod() == 1) {
            statusPageComponent.setState(statusPageComponent.getConfigState());
        }
        this.statusPageComponentDao.save(statusPageComponent);
    }

    @Override
    public void deleteStatusPageComponent(long id) {
        long count = this.statusPageIncidentComponentBindDao.countByComponentId(id);
        if (count != 0L) {
            throw new CommonException("The component is associated with an event and cannot be deleted. Please delete the event and try again!");
        }
        this.statusPageComponentDao.deleteById(id);
    }

    @Override
    public StatusPageComponent queryStatusPageComponent(long id) {
        return this.statusPageComponentDao.findById(id).orElse(null);
    }

    @Override
    public List<ComponentStatus> queryComponentsStatus() {
        Iterable components = this.statusPageComponentDao.findAll();
        LinkedList<ComponentStatus> componentStatusList = new LinkedList<ComponentStatus>();
        for (StatusPageComponent component : components) {
            ComponentStatus componentStatus = new ComponentStatus();
            componentStatus.setInfo(component);
            LinkedList<StatusPageHistory> histories = new LinkedList<StatusPageHistory>();
            LocalDateTime nowTime = LocalDateTime.now();
            LocalDateTime todayStartTime = nowTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
            ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
            long nowTimestamp = nowTime.toInstant(zoneOffset).toEpochMilli();
            long todayStartTimestamp = todayStartTime.toInstant(zoneOffset).toEpochMilli();
            List<StatusPageHistory> todayStatusPageHistoryList = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), todayStartTimestamp, nowTimestamp);
            StatusPageHistory todayStatus = this.combineOneDayStatusPageHistory(todayStatusPageHistoryList, component, nowTimestamp);
            histories.add(todayStatus);
            LocalDateTime preTime = todayStartTime.minusDays(29L);
            long preTimestamp = preTime.toInstant(zoneOffset).toEpochMilli();
            List<StatusPageHistory> history = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), preTimestamp, todayStartTimestamp);
            LinkedList<StatusPageHistory> historyList = new LinkedList<StatusPageHistory>(history);
            historyList.sort((o1, o2) -> (int)(o1.getTimestamp() - o2.getTimestamp()));
            LocalDateTime endTime = todayStartTime.minusSeconds(1L);
            LocalDateTime startTime = endTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
            for (int index = 0; index < 29; ++index) {
                long startTimestamp = startTime.toInstant(zoneOffset).toEpochMilli();
                long endTimestamp = endTime.toInstant(zoneOffset).toEpochMilli();
                List<StatusPageHistory> thisDayHistory = historyList.stream().filter(item -> item.getTimestamp() >= startTimestamp && item.getTimestamp() <= endTimestamp).collect(Collectors.toList());
                if (thisDayHistory.isEmpty()) {
                    statusPageHistory = StatusPageHistory.builder().timestamp(endTimestamp).componentId(component.getId()).state((byte)2).build();
                    histories.add(statusPageHistory);
                } else if (thisDayHistory.size() == 1) {
                    histories.add((StatusPageHistory)thisDayHistory.get(0));
                } else {
                    statusPageHistory = this.combineOneDayStatusPageHistory(thisDayHistory, component, endTimestamp);
                    histories.add(statusPageHistory);
                    this.statusPageHistoryDao.deleteAll(thisDayHistory);
                    this.statusPageHistoryDao.save(statusPageHistory);
                }
                startTime = startTime.minusDays(1L);
                endTime = endTime.minusDays(1L);
            }
            componentStatus.setHistory(histories);
            componentStatusList.add(componentStatus);
        }
        return componentStatusList;
    }

    private StatusPageHistory combineOneDayStatusPageHistory(List<StatusPageHistory> statusPageHistories, StatusPageComponent component, long nowTimestamp) {
        if (statusPageHistories.isEmpty()) {
            return StatusPageHistory.builder().timestamp(nowTimestamp).normal(0).abnormal(0).unknowing(0).componentId(component.getId()).state(component.getState()).build();
        }
        if (statusPageHistories.size() == 1) {
            return statusPageHistories.get(0);
        }
        StatusPageHistory oldOne = statusPageHistories.get(0);
        StatusPageHistory todayStatus = StatusPageHistory.builder().timestamp(nowTimestamp).normal(0).abnormal(0).unknowing(0).gmtCreate(oldOne.getGmtCreate()).gmtUpdate(oldOne.getGmtUpdate()).componentId(component.getId()).state(component.getState()).build();
        for (StatusPageHistory statusPageHistory : statusPageHistories) {
            if (statusPageHistory.getState() == 1) {
                todayStatus.setAbnormal(todayStatus.getAbnormal() + this.calculateStatus.getCalculateStatusIntervals());
                continue;
            }
            if (statusPageHistory.getState() == 2) {
                todayStatus.setUnknowing(todayStatus.getUnknowing() + this.calculateStatus.getCalculateStatusIntervals());
                continue;
            }
            todayStatus.setNormal(todayStatus.getNormal() + this.calculateStatus.getCalculateStatusIntervals());
        }
        double total = todayStatus.getNormal() + todayStatus.getAbnormal() + todayStatus.getUnknowing();
        double uptime = 0.0;
        if (total > 0.0) {
            uptime = (double)todayStatus.getNormal().intValue() / total;
        }
        todayStatus.setUptime(uptime);
        if (todayStatus.getAbnormal() > 0) {
            todayStatus.setState((byte)1);
        } else if (todayStatus.getNormal() > 0) {
            todayStatus.setState((byte)0);
        } else {
            todayStatus.setState((byte)2);
        }
        return todayStatus;
    }

    @Override
    public ComponentStatus queryComponentStatus(long id) {
        StatusPageComponent component = (StatusPageComponent)this.statusPageComponentDao.findById(id).orElseThrow(() -> new IllegalArgumentException("component not found"));
        ComponentStatus componentStatus = new ComponentStatus();
        componentStatus.setInfo(component);
        LinkedList<StatusPageHistory> histories = new LinkedList<StatusPageHistory>();
        LocalDateTime nowTime = LocalDateTime.now();
        LocalDateTime todayStartTime = nowTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
        long nowTimestamp = nowTime.toInstant(zoneOffset).toEpochMilli();
        long todayStartTimestamp = todayStartTime.toInstant(zoneOffset).toEpochMilli();
        List<StatusPageHistory> todayStatusPageHistoryList = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), todayStartTimestamp, nowTimestamp);
        StatusPageHistory todayStatus = this.combineOneDayStatusPageHistory(todayStatusPageHistoryList, component, nowTimestamp);
        histories.add(todayStatus);
        LocalDateTime preTime = todayStartTime.minusDays(29L);
        long preTimestamp = preTime.toInstant(zoneOffset).toEpochMilli();
        List<StatusPageHistory> history = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), preTimestamp, todayStartTimestamp);
        LinkedList<StatusPageHistory> historyList = new LinkedList<StatusPageHistory>(history);
        historyList.sort((o1, o2) -> (int)(o1.getTimestamp() - o2.getTimestamp()));
        LocalDateTime endTime = todayStartTime.minusSeconds(1L);
        LocalDateTime startTime = endTime.withHour(0).withMinute(0).withSecond(0).withNano(0);
        for (int index = 0; index < 29; ++index) {
            long startTimestamp = startTime.toInstant(zoneOffset).toEpochMilli();
            long endTimestamp = endTime.toInstant(zoneOffset).toEpochMilli();
            List<StatusPageHistory> thisDayHistory = historyList.stream().filter(item -> item.getTimestamp() >= startTimestamp && item.getTimestamp() <= endTimestamp).collect(Collectors.toList());
            if (thisDayHistory.isEmpty()) {
                statusPageHistory = StatusPageHistory.builder().timestamp(endTimestamp).componentId(component.getId()).state((byte)2).build();
                histories.add(statusPageHistory);
            } else if (thisDayHistory.size() == 1) {
                histories.add((StatusPageHistory)thisDayHistory.get(0));
            } else {
                statusPageHistory = this.combineOneDayStatusPageHistory(thisDayHistory, component, endTimestamp);
                histories.add(statusPageHistory);
                this.statusPageHistoryDao.deleteAll(thisDayHistory);
                this.statusPageHistoryDao.save(statusPageHistory);
            }
            startTime = startTime.minusDays(1L);
            endTime = endTime.minusDays(1L);
        }
        componentStatus.setHistory(histories);
        return componentStatus;
    }

    @Override
    public Page<StatusPageIncident> queryStatusPageIncidents(String search, Long startTime, Long endTime, int pageIndex, int pageSize) {
        Specification specification = (root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (StringUtils.hasText(search)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower(root.get("name")), "%" + search.toLowerCase() + "%");
                andList.add(predicateName);
            }
            if (startTime != null) {
                andList.add(criteriaBuilder.greaterThanOrEqualTo(root.get("startTime"), startTime));
            }
            if (endTime != null) {
                andList.add(criteriaBuilder.lessThanOrEqualTo(root.get("endTime"), endTime));
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sort = Sort.by(Sort.Direction.DESC, "startTime");
        PageRequest pageRequest = PageRequest.of(pageIndex, pageSize, sort);
        return this.statusPageIncidentDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public StatusPageIncident queryStatusPageIncident(long id) {
        return this.statusPageIncidentDao.findById(id).orElse(null);
    }

    @Override
    public void newStatusPageIncident(StatusPageIncident statusPageIncident) {
        statusPageIncident.setStartTime(System.currentTimeMillis());
        if (statusPageIncident.getState() == 3) {
            statusPageIncident.setEndTime(System.currentTimeMillis());
        }
        this.statusPageIncidentDao.save(statusPageIncident);
    }

    @Override
    public void updateStatusPageIncident(StatusPageIncident statusPageIncident) {
        if (statusPageIncident.getState() == 3) {
            statusPageIncident.setEndTime(System.currentTimeMillis());
        }
        this.statusPageIncidentDao.save(statusPageIncident);
    }

    @Override
    public void deleteStatusPageIncident(long id) {
        this.statusPageIncidentDao.deleteById(id);
    }

    public StatusPageServiceImpl(StatusPageIncidentComponentBindDao statusPageIncidentComponentBindDao) {
        this.statusPageIncidentComponentBindDao = statusPageIncidentComponentBindDao;
    }
}

