/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.obs.services.ObsClient;
import java.lang.reflect.Type;
import java.net.URL;
import javax.annotation.Resource;
import org.apache.hertzbeat.base.dao.GeneralConfigDao;
import org.apache.hertzbeat.common.constants.GeneralConfigTypeEnum;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreConfigChangeEvent;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreDTO;
import org.apache.hertzbeat.manager.service.impl.AbstractGeneralConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.ObsObjectStoreServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Order(value=-2147483648)
@Service
public class ObjectStoreConfigServiceImpl
extends AbstractGeneralConfigServiceImpl<ObjectStoreDTO<ObjectStoreDTO.ObsConfig>>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ObjectStoreConfigServiceImpl.class);
    private static final String BEAN_NAME = "ObjectStoreService";
    @Resource
    private DefaultListableBeanFactory beanFactory;
    @Resource
    private ApplicationContext ctx;

    public ObjectStoreConfigServiceImpl(GeneralConfigDao generalConfigDao, ObjectMapper objectMapper) {
        super(generalConfigDao, objectMapper);
    }

    @Override
    public String type() {
        return GeneralConfigTypeEnum.oss.name();
    }

    @Override
    public TypeReference<ObjectStoreDTO<ObjectStoreDTO.ObsConfig>> getTypeReference() {
        return new TypeReference<ObjectStoreDTO<ObjectStoreDTO.ObsConfig>>(){

            @Override
            public Type getType() {
                return ObjectStoreDTO.class;
            }
        };
    }

    @Override
    public void handler(ObjectStoreDTO<ObjectStoreDTO.ObsConfig> config) {
        if (config != null) {
            if (config.getType() == ObjectStoreDTO.Type.OBS) {
                this.initObs(config);
            }
            this.ctx.publishEvent(new ObjectStoreConfigChangeEvent(config));
        }
        log.warn("object store config is null, please check the configuration file.");
    }

    private void initObs(ObjectStoreDTO<ObjectStoreDTO.ObsConfig> config) {
        ObjectStoreDTO.ObsConfig obsConfig = this.objectMapper.convertValue((Object)config.getConfig(), ObjectStoreDTO.ObsConfig.class);
        Assert.hasText(obsConfig.getAccessKey(), "cannot find obs accessKey");
        Assert.hasText(obsConfig.getSecretKey(), "cannot find obs secretKey");
        Assert.hasText(obsConfig.getEndpoint(), "cannot find obs endpoint");
        Assert.hasText(obsConfig.getBucketName(), "cannot find obs bucket name");
        this.validateObsEndpoint(obsConfig.getEndpoint());
        ObsClient obsClient = new ObsClient(obsConfig.getAccessKey(), obsConfig.getSecretKey(), obsConfig.getEndpoint());
        this.beanFactory.destroySingleton(BEAN_NAME);
        this.beanFactory.registerSingleton(BEAN_NAME, new ObsObjectStoreServiceImpl(obsClient, obsConfig.getBucketName(), obsConfig.getSavePath()));
        log.info("obs store service init success.");
    }

    public void validateObsEndpoint(String endpoint) {
        try {
            URL url = new URL(endpoint);
            String host = url.getHost();
            if (!host.endsWith(".myhuaweicloud.com")) {
                throw new IllegalArgumentException("Invalid OBS endpoint domain. Only myhuaweicloud.com is allowed");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid OBS endpoint: " + e.getMessage());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.handler((ObjectStoreDTO)this.getConfig());
    }
}

