/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import java.util.concurrent.Executor;

public interface Observer<V> {
    public void onNext(V var1);

    public void onError(Throwable var1);

    default public void onCompleted() {
    }

    default public Executor executor() {
        return null;
    }

    public static class RejectedObserver<V>
    implements Observer<V> {
        private final Throwable err;

        public RejectedObserver(Throwable err) {
            this.err = err;
        }

        @Override
        public void onNext(V value) {
            this.reject();
        }

        @Override
        public void onError(Throwable err) {
            this.reject();
        }

        @Override
        public void onCompleted() {
            this.reject();
        }

        private void reject() {
            throw new RuntimeException(this.err);
        }
    }
}

