/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.factory;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.apache.helix.zookeeper.impl.client.SharedZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.impl.factory.HelixZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.ZkConnectionManager;
import org.apache.helix.zookeeper.zkclient.IZkConnection;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedZkClientFactory
extends HelixZkClientFactory {
    private static Logger LOG = LoggerFactory.getLogger(SharedZkClientFactory.class);
    private final HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> _connectionManagerPool = new HashMap();
    private static final ZkConnection IDLE_CONNECTION = new ZkConnection("Dummy_ZkServers");

    protected SharedZkClientFactory() {
    }

    @Override
    public RealmAwareZkClient buildZkClient(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) throws InvalidRoutingDataException {
        return new SharedZkClient(connectionConfig, clientConfig);
    }

    public static SharedZkClientFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixZkClient buildZkClient(HelixZkClient.ZkConnectionConfig connectionConfig, HelixZkClient.ZkClientConfig clientConfig) {
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            final ZkConnectionManager zkConnectionManager = this.getOrCreateZkConnectionManager(connectionConfig, clientConfig.getConnectInitTimeout());
            if (zkConnectionManager == null) {
                throw new ZkClientException("Failed to create a connection manager in the pool to share.");
            }
            LOG.info("Sharing ZkConnection {} to a new InnerSharedZkClient.", (Object)connectionConfig.toString());
            return new InnerSharedZkClient(zkConnectionManager, clientConfig, new OnCloseCallback(){

                @Override
                public void onClose() {
                    SharedZkClientFactory.this.cleanupConnectionManager(zkConnectionManager);
                }
            });
        }
    }

    private ZkConnectionManager getOrCreateZkConnectionManager(HelixZkClient.ZkConnectionConfig connectionConfig, long connectInitTimeout) {
        ZkConnectionManager connectionManager = this._connectionManagerPool.get(connectionConfig);
        if (connectionManager == null || connectionManager.isClosed()) {
            connectionManager = new ZkConnectionManager(this.createZkConnection(connectionConfig), connectInitTimeout, connectionConfig.toString());
            this._connectionManagerPool.put(connectionConfig, connectionManager);
        }
        return connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnectionManager(ZkConnectionManager zkConnectionManager) {
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            zkConnectionManager.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getActiveConnectionCount() {
        int count = 0;
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            for (ZkConnectionManager manager : this._connectionManagerPool.values()) {
                if (manager.isClosed()) continue;
                ++count;
            }
        }
        return count;
    }

    public static class InnerSharedZkClient
    extends ZkClient
    implements HelixZkClient {
        private final OnCloseCallback _onCloseCallback;
        private final ZkConnectionManager _connectionManager;

        public InnerSharedZkClient(ZkConnectionManager connectionManager, HelixZkClient.ZkClientConfig clientConfig, OnCloseCallback callback) {
            super(connectionManager.getConnection(), 0, clientConfig.getOperationRetryTimeout(), clientConfig.getZkSerializer(), clientConfig.getMonitorType(), clientConfig.getMonitorKey(), clientConfig.getMonitorInstanceName(), clientConfig.isMonitorRootPathOnly());
            this._connectionManager = connectionManager;
            this._connectionManager.registerWatcher(this);
            this._onCloseCallback = callback;
        }

        @Override
        public void close() {
            super.close();
            if (this.isClosed()) {
                if (this._connectionManager != null) {
                    this._connectionManager.unregisterWatcher(this);
                }
                if (this._onCloseCallback != null) {
                    this._onCloseCallback.onClose();
                }
            }
        }

        @Override
        public IZkConnection getConnection() {
            if (this.isClosed()) {
                return IDLE_CONNECTION;
            }
            return super.getConnection();
        }

        @Override
        public String create(String path, Object datat, List<ACL> acl, CreateMode mode) {
            return this.create(path, datat, acl, mode, -1L);
        }

        @Override
        public String create(String path, Object datat, List<ACL> acl, CreateMode mode, long ttl) {
            if (mode.isEphemeral()) {
                throw new UnsupportedOperationException("Create ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
            }
            return super.create(path, datat, acl, mode, ttl);
        }

        @Override
        protected boolean isManagingZkConnection() {
            return false;
        }
    }

    public static interface OnCloseCallback {
        public void onClose();
    }

    private static class SingletonHelper {
        private static final SharedZkClientFactory INSTANCE = new SharedZkClientFactory();

        private SingletonHelper() {
        }
    }
}

