/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NavigableSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AggregateImplementation<T, S, P extends Message, Q extends Message, R extends Message>
extends AggregateProtos.AggregateService
implements RegionCoprocessor {
    protected static final Logger log = LoggerFactory.getLogger(AggregateImplementation.class);
    private RegionCoprocessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getMax(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        Object max;
        AggregateProtos.AggregateResponse response;
        block10: {
            RegionScanner scanner = null;
            response = null;
            max = null;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                ArrayList results = new ArrayList();
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                boolean hasMoreRows = false;
                do {
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                        max = max == null || temp != null && ci.compare(temp, max) > 0 ? temp : max;
                    }
                    results.clear();
                } while (hasMoreRows);
                if (max != null) {
                    AggregateProtos.AggregateResponse.Builder builder = AggregateProtos.AggregateResponse.newBuilder();
                    builder.addFirstPart(ci.getProtoForCellType(max).toByteString());
                    response = builder.build();
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        log.info("Maximum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + max);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getMin(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        Object min;
        AggregateProtos.AggregateResponse response;
        block10: {
            response = null;
            RegionScanner scanner = null;
            min = null;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                ArrayList results = new ArrayList();
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                boolean hasMoreRows = false;
                do {
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                        min = min == null || temp != null && ci.compare(temp, min) < 0 ? temp : min;
                    }
                    results.clear();
                } while (hasMoreRows);
                if (min != null) {
                    response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(min).toByteString()).build();
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        log.info("Minimum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + min);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getSum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        long sum;
        AggregateProtos.AggregateResponse response;
        block10: {
            response = null;
            RegionScanner scanner = null;
            sum = 0L;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Object sumVal = null;
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                ArrayList results = new ArrayList();
                boolean hasMoreRows = false;
                do {
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                        if (temp == null) continue;
                        sumVal = ci.add(sumVal, ci.castToReturnType(temp));
                    }
                    results.clear();
                } while (hasMoreRows);
                if (sumVal != null) {
                    response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForPromotedType(sumVal).toByteString()).build();
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        log.debug("Sum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + sum);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRowNum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        long counter;
        AggregateProtos.AggregateResponse response;
        block10: {
            response = null;
            counter = 0L;
            ArrayList results = new ArrayList();
            RegionScanner scanner = null;
            try {
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                byte[][] colFamilies = scan.getFamilies();
                byte[] colFamily = colFamilies != null ? colFamilies[0] : null;
                NavigableSet qualifiers = colFamilies != null ? (NavigableSet)scan.getFamilyMap().get(colFamily) : null;
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                if (scan.getFilter() == null && qualifier == null) {
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                }
                scanner = this.env.getRegion().getScanner(scan);
                boolean hasMoreRows = false;
                do {
                    hasMoreRows = scanner.next(results);
                    if (results.size() > 0) {
                        ++counter;
                    }
                    results.clear();
                } while (hasMoreRows);
                ByteBuffer bb = ByteBuffer.allocate(8).putLong(counter);
                bb.rewind();
                response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ByteString.copyFrom((ByteBuffer)bb)).build();
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        log.info("Row counter from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + counter);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getAvg(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block10: {
            response = null;
            RegionScanner scanner = null;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Object sumVal = null;
                Long rowCountVal = 0L;
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                ArrayList results = new ArrayList();
                boolean hasMoreRows = false;
                do {
                    results.clear();
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        sumVal = ci.add(sumVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                    }
                    Long i = rowCountVal;
                    Long l = rowCountVal = Long.valueOf(rowCountVal + 1L);
                } while (hasMoreRows);
                if (sumVal != null) {
                    ByteString first = ci.getProtoForPromotedType(sumVal).toByteString();
                    AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                    pair.addFirstPart(first);
                    ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                    bb.rewind();
                    pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                    response = pair.build();
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getStd(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block10: {
            RegionScanner scanner = null;
            response = null;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Object sumVal = null;
                Object sumSqVal = null;
                Object tempVal = null;
                long rowCountVal = 0L;
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] qualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    qualifier = (byte[])qualifiers.pollFirst();
                }
                ArrayList results = new ArrayList();
                boolean hasMoreRows = false;
                do {
                    tempVal = null;
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                    }
                    results.clear();
                    sumVal = ci.add(sumVal, tempVal);
                    sumSqVal = ci.add(sumSqVal, ci.multiply(tempVal, tempVal));
                    ++rowCountVal;
                } while (hasMoreRows);
                if (sumVal != null) {
                    ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                    ByteString first_sumSqVal = ci.getProtoForPromotedType(sumSqVal).toByteString();
                    AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                    pair.addFirstPart(first_sumVal);
                    pair.addFirstPart(first_sumSqVal);
                    ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                    bb.rewind();
                    pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                    response = pair.build();
                }
                if (scanner == null) break block10;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block10;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block10;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getMedian(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block9: {
            response = null;
            RegionScanner scanner = null;
            try {
                ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                Object sumVal = null;
                Object sumWeights = null;
                Object tempVal = null;
                Object tempWeight = null;
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                scanner = this.env.getRegion().getScanner(scan);
                byte[] colFamily = scan.getFamilies()[0];
                NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                byte[] valQualifier = null;
                byte[] weightQualifier = null;
                if (qualifiers != null && !qualifiers.isEmpty()) {
                    valQualifier = (byte[])qualifiers.pollFirst();
                    weightQualifier = (byte[])qualifiers.pollLast();
                }
                ArrayList results = new ArrayList();
                boolean hasMoreRows = false;
                do {
                    tempVal = null;
                    tempWeight = null;
                    hasMoreRows = scanner.next(results);
                    int listSize = results.size();
                    for (int i = 0; i < listSize; ++i) {
                        Cell kv = (Cell)results.get(i);
                        tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, valQualifier, kv)));
                        if (weightQualifier == null) continue;
                        tempWeight = ci.add(tempWeight, ci.castToReturnType(ci.getValue(colFamily, weightQualifier, kv)));
                    }
                    results.clear();
                    sumVal = ci.add(sumVal, tempVal);
                    sumWeights = ci.add(sumWeights, tempWeight);
                } while (hasMoreRows);
                ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                Object s = sumWeights == null ? ci.castToReturnType(ci.getMinValue()) : sumWeights;
                ByteString first_sumWeights = ci.getProtoForPromotedType(s).toByteString();
                AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                pair.addFirstPart(first_sumVal);
                pair.addFirstPart(first_sumWeights);
                response = pair.build();
                if (scanner == null) break block9;
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                break block9;
            }
            IOUtils.closeQuietly((Closeable)scanner);
            break block9;
            finally {
                if (scanner != null) {
                    IOUtils.closeQuietly(scanner);
                }
            }
        }
        done.run(response);
    }

    ColumnInterpreter<T, S, P, Q, R> constructColumnInterpreterFromRequest(AggregateProtos.AggregateRequest request) throws IOException {
        String className = request.getInterpreterClassName();
        try {
            Class<?> cls = Class.forName(className);
            ColumnInterpreter ci = (ColumnInterpreter)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (request.hasInterpreterSpecificBytes()) {
                ByteString b = request.getInterpreterSpecificBytes();
                Object initMsg = AggregationHelper.getParsedGenericInstance(ci.getClass(), 2, b);
                ci.initialize(initMsg);
            }
            return ci;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

