/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.security.Permission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ZKMainServer;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, SmallTests.class})
public class TestZKMainServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKMainServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLineWorks() throws Exception {
        System.setSecurityManager(new NoExitSecurityManager());
        HBaseZKTestingUtil htu = new HBaseZKTestingUtil();
        htu.getConfiguration().setInt("zookeeper.session.timeout", 30000);
        htu.startMiniZKCluster();
        try {
            ZKWatcher zkw = htu.getZooKeeperWatcher();
            String znode = "/testCommandLineWorks";
            ZKUtil.createWithParents((ZKWatcher)zkw, (String)znode, (byte[])HConstants.EMPTY_BYTE_ARRAY);
            ZKUtil.checkExists((ZKWatcher)zkw, (String)znode);
            boolean exception = false;
            try {
                ZKMainServer.main((String[])new String[]{"-server", htu.getZkCluster().getAddress().toString(), "delete", znode});
            }
            catch (ExitException ee) {
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
            Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)zkw, (String)znode));
        }
        finally {
            htu.shutdownMiniZKCluster();
            System.setSecurityManager(null);
        }
    }

    @Test
    public void testHostPortParse() {
        ZKMainServer parser = new ZKMainServer();
        Configuration c = HBaseConfiguration.create();
        Assert.assertEquals((Object)("127.0.0.1:" + c.get("hbase.zookeeper.property.clientPort")), (Object)parser.parse(c));
        String port = "1234";
        c.set("hbase.zookeeper.property.clientPort", "1234");
        c.set("hbase.zookeeper.quorum", "example.com");
        Assert.assertEquals((Object)"example.com:1234", (Object)parser.parse(c));
        c.set("hbase.zookeeper.quorum", "example1.com,example2.com,example3.com");
        String ensemble = parser.parse(c);
        Assert.assertTrue((String)"1234", (boolean)ensemble.matches("(example[1-3]\\.com:1234,){2}example[1-3]\\.com:1234"));
        c.set("hbase.zookeeper.quorum", "example1.com:5678,example2.com:9012,example3.com:3456");
        ensemble = parser.parse(c);
        Assert.assertEquals((Object)"example1.com:5678,example2.com:9012,example3.com:3456", (Object)ensemble);
        c.set("hbase.zookeeper.quorum", "example1.com:5678,example2.com:9012,example3.com");
        ensemble = parser.parse(c);
        Assert.assertEquals((Object)ensemble, (Object)"example1.com:5678,example2.com:9012,example3.com:1234");
        c.set("hbase.zookeeper.quorum", "[2001:db8:1::242:ac11:2]:2181,[2001:db8:1::242:ac11:3]:5678");
        ensemble = parser.parse(c);
        Assert.assertEquals((Object)"[2001:db8:1::242:ac11:2]:2181,[2001:db8:1::242:ac11:3]:5678", (Object)ensemble);
        c.set("hbase.zookeeper.quorum", "[1001:db8:1::242:ac11:8], [2001:db8:1::242:df23:2]:9876,[2001:db8:1::242:ac11:3]:5678");
        ensemble = parser.parse(c);
        Assert.assertEquals((Object)"[1001:db8:1::242:ac11:8]:1234, [2001:db8:1::242:df23:2]:9876,[2001:db8:1::242:ac11:3]:5678", (Object)ensemble);
        try {
            c.set("hbase.zookeeper.quorum", "[1001:db8:1::242:ac11:8], [2001:db8:1::242:df23:2]:9876,[1001:db8:1::242:ac11:8:89:67]:5678");
            parser.parse(c);
            Assert.fail((String)"IPv6 address should be 8 groups.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ExitException();
        }
    }

    protected static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = 1L;

        ExitException() {
            super("There is no escape!");
        }
    }
}

