/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALTailingReader;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LeaseNotRecoveredException;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.DisabledWALProvider;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.LazyInitializedWALProvider;
import org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hadoop.hbase.wal.WALTailingReader;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class WALFactory {
    public static final String WAL_STREAM_READER_CLASS_IMPL = "hbase.regionserver.wal.stream.reader.impl";
    private static final Logger LOG = LoggerFactory.getLogger(WALFactory.class);
    public static final String WAL_PROVIDER = "hbase.wal.provider";
    static final String DEFAULT_WAL_PROVIDER = Providers.defaultProvider.name();
    public static final String META_WAL_PROVIDER = "hbase.wal.meta_provider";
    public static final String REPLICATION_WAL_PROVIDER = "hbase.wal.replication_provider";
    public static final String WAL_ENABLED = "hbase.regionserver.hlog.enabled";
    static final String REPLICATION_WAL_PROVIDER_ID = "rep";
    final String factoryId;
    final Abortable abortable;
    private final WALProvider provider;
    private final LazyInitializedWALProvider metaProvider;
    private final LazyInitializedWALProvider replicationProvider;
    private final Class<? extends WALStreamReader> walStreamReaderClass;
    private final int timeoutMillis;
    private final Configuration conf;
    private final ExcludeDatanodeManager excludeDatanodeManager;
    private static final AtomicReference<WALFactory> singleton = new AtomicReference();
    private static final String SINGLETON_ID = WALFactory.class.getName();

    private WALFactory(Configuration conf) {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.walStreamReaderClass = conf.getClass(WAL_STREAM_READER_CLASS_IMPL, ProtobufWALStreamReader.class, WALStreamReader.class);
        Preconditions.checkArgument(AbstractFSWALProvider.Initializer.class.isAssignableFrom(this.walStreamReaderClass), "The wal stream reader class %s is not a sub class of %s", (Object)this.walStreamReaderClass.getName(), (Object)AbstractFSWALProvider.Initializer.class.getName());
        this.conf = conf;
        this.provider = null;
        this.factoryId = SINGLETON_ID;
        this.abortable = null;
        this.excludeDatanodeManager = new ExcludeDatanodeManager(conf);
        this.metaProvider = null;
        this.replicationProvider = null;
    }

    Providers getDefaultProvider() {
        return Providers.defaultProvider;
    }

    Class<? extends WALProvider> getProviderClass(String key, String defaultValue) {
        try {
            Providers provider = Providers.valueOf(this.conf.get(key, defaultValue));
            if (provider == this.getDefaultProvider() && provider.clazz == AsyncFSWALProvider.class && !AsyncFSWALProvider.load()) {
                LOG.warn("Failed to load AsyncFSWALProvider, falling back to FSHLogProvider");
                return FSHLogProvider.class;
            }
            return provider.clazz;
        }
        catch (IllegalArgumentException exception) {
            return this.conf.getClass(key, Providers.defaultProvider.clazz, WALProvider.class);
        }
    }

    static WALProvider createProvider(Class<? extends WALProvider> clazz) throws IOException {
        LOG.info("Instantiating WALProvider of type {}", clazz);
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("couldn't set up WALProvider, the configured class is " + clazz);
            LOG.debug("Exception details for failure to load WALProvider.", (Throwable)e);
            throw new IOException("couldn't set up WALProvider", e);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*|.*/HBaseTestingUtility.java")
    public WALFactory(Configuration conf, String factoryId) throws IOException {
        this(conf, factoryId, null);
    }

    public WALFactory(Configuration conf, ServerName serverName, Abortable abortable) throws IOException {
        this(conf, serverName.toString(), abortable);
    }

    private WALFactory(Configuration conf, String factoryId, Abortable abortable) throws IOException {
        this.timeoutMillis = conf.getInt("hbase.hlog.open.timeout", 300000);
        this.walStreamReaderClass = conf.getClass(WAL_STREAM_READER_CLASS_IMPL, ProtobufWALStreamReader.class, WALStreamReader.class);
        Preconditions.checkArgument(AbstractFSWALProvider.Initializer.class.isAssignableFrom(this.walStreamReaderClass), "The wal stream reader class %s is not a sub class of %s", (Object)this.walStreamReaderClass.getName(), (Object)AbstractFSWALProvider.Initializer.class.getName());
        this.conf = conf;
        this.factoryId = factoryId;
        this.excludeDatanodeManager = new ExcludeDatanodeManager(conf);
        this.abortable = abortable;
        this.metaProvider = new LazyInitializedWALProvider(this, ".meta", META_WAL_PROVIDER, this.abortable);
        this.replicationProvider = new LazyInitializedWALProvider(this, REPLICATION_WAL_PROVIDER_ID, REPLICATION_WAL_PROVIDER, this.abortable);
        if (conf.getBoolean(WAL_ENABLED, true)) {
            WALProvider provider = WALFactory.createProvider(this.getProviderClass(WAL_PROVIDER, DEFAULT_WAL_PROVIDER));
            provider.init(this, conf, null, this.abortable);
            provider.addWALActionsListener(new MetricsWAL());
            this.provider = provider;
        } else {
            LOG.warn("Running with WAL disabled.");
            this.provider = new DisabledWALProvider();
            this.provider.init(this, conf, factoryId, null);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void close() throws IOException {
        ArrayList<IOException> ioes = new ArrayList<IOException>();
        if (this.metaProvider != null) {
            try {
                this.metaProvider.close();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (this.replicationProvider != null) {
            try {
                this.replicationProvider.close();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (!ioes.isEmpty()) {
            IOException ioe = new IOException("Failed to close WALFactory");
            for (IOException e : ioes) {
                ioe.addSuppressed(e);
            }
            throw ioe;
        }
    }

    public void shutdown() throws IOException {
        ArrayList<IOException> ioes = new ArrayList<IOException>();
        if (this.metaProvider != null) {
            try {
                this.metaProvider.shutdown();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (this.replicationProvider != null) {
            try {
                this.replicationProvider.shutdown();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (this.provider != null) {
            try {
                this.provider.shutdown();
            }
            catch (IOException e) {
                ioes.add(e);
            }
        }
        if (!ioes.isEmpty()) {
            IOException ioe = new IOException("Failed to shutdown WALFactory");
            for (IOException e : ioes) {
                ioe.addSuppressed(e);
            }
            throw ioe;
        }
    }

    public List<WAL> getWALs() {
        return this.provider.getWALs();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    WALProvider getMetaProvider() throws IOException {
        return this.metaProvider.getProvider();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    WALProvider getReplicationProvider() throws IOException {
        return this.replicationProvider.getProvider();
    }

    public WAL getWAL(RegionInfo region) throws IOException {
        if (region != null && RegionReplicaUtil.isDefaultReplica(region)) {
            if (region.isMetaRegion()) {
                return this.metaProvider.getProvider().getWAL(region);
            }
            if (ReplicationStorageFactory.isReplicationQueueTable(this.conf, region.getTable())) {
                return this.replicationProvider.getProvider().getWAL(region);
            }
        }
        return this.provider.getWAL(region);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path) throws IOException {
        return this.createStreamReader(fs, path, null);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path, CancelableProgressable reporter) throws IOException {
        return this.createStreamReader(fs, path, reporter, -1L);
    }

    public WALStreamReader createStreamReader(FileSystem fs, Path path, CancelableProgressable reporter, long startPosition) throws IOException {
        try {
            long startWaiting = EnvironmentEdgeManager.currentTime();
            long openTimeout = (long)this.timeoutMillis + startWaiting;
            int nbAttempt = 0;
            WALStreamReader reader = null;
            while (true) {
                try {
                    reader = this.walStreamReaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ((AbstractFSWALProvider.Initializer)((Object)reader)).init(fs, path, this.conf, startPosition);
                    return reader;
                }
                catch (Exception e) {
                    String msg;
                    if (reader != null) {
                        reader.close();
                    }
                    if (e instanceof IOException && (msg = e.getMessage()) != null && (msg.contains("Cannot obtain block length") || msg.contains("Could not obtain the last block") || msg.matches("Blocklist for [^ ]* has changed.*"))) {
                        if (++nbAttempt == 1) {
                            LOG.warn("Lease should have recovered. This is not expected. Will retry", (Throwable)e);
                        }
                        if (reporter != null && !reporter.progress()) {
                            throw new InterruptedIOException("Operation is cancelled");
                        }
                        if (nbAttempt <= 2 || openTimeout >= EnvironmentEdgeManager.currentTime()) {
                            try {
                                Thread.sleep(nbAttempt < 3 ? 500L : 1000L);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException iioe = new InterruptedIOException();
                                iioe.initCause(ie);
                                throw iioe;
                            }
                            continue;
                        }
                        LOG.error("Can't open after " + nbAttempt + " attempts and " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms  for " + path);
                        throw new LeaseNotRecoveredException(e);
                    }
                    throw e;
                }
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public WALProvider.Writer createWALWriter(FileSystem fs, Path path) throws IOException {
        return FSHLogProvider.createWriter(this.conf, fs, path, false);
    }

    public WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path) throws IOException {
        return FSHLogProvider.createWriter(this.conf, fs, path, true);
    }

    public static WALFactory getInstance(Configuration configuration) {
        WALFactory factory = singleton.get();
        if (null == factory) {
            WALFactory temp = new WALFactory(configuration);
            if (singleton.compareAndSet(null, temp)) {
                factory = temp;
            } else {
                try {
                    temp.close();
                }
                catch (IOException exception) {
                    LOG.debug("failed to close temporary singleton. ignoring.", (Throwable)exception);
                }
                factory = singleton.get();
            }
        }
        return factory;
    }

    public static WALTailingReader createTailingReader(FileSystem fs, Path path, Configuration conf, long startPosition) throws IOException {
        ProtobufWALTailingReader reader = new ProtobufWALTailingReader();
        reader.init(fs, path, conf, startPosition);
        return reader;
    }

    public static WALStreamReader createStreamReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return WALFactory.createStreamReader(fs, path, conf, -1L);
    }

    public static WALStreamReader createStreamReader(FileSystem fs, Path path, Configuration conf, long startPosition) throws IOException {
        return WALFactory.getInstance(conf).createStreamReader(fs, path, null, startPosition);
    }

    static WALProvider.Writer createRecoveredEditsWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return FSHLogProvider.createWriter(configuration, fs, path, true);
    }

    public static WALProvider.Writer createWALWriter(FileSystem fs, Path path, Configuration configuration) throws IOException {
        return FSHLogProvider.createWriter(configuration, fs, path, false);
    }

    public WALProvider getWALProvider() {
        return this.provider;
    }

    public List<WALProvider> getAllWALProviders() {
        WALProvider replication;
        WALProvider meta;
        ArrayList<WALProvider> providers = new ArrayList<WALProvider>();
        if (this.provider != null) {
            providers.add(this.provider);
        }
        if ((meta = this.metaProvider.getProviderNoCreate()) != null) {
            providers.add(meta);
        }
        if ((replication = this.replicationProvider.getProviderNoCreate()) != null) {
            providers.add(replication);
        }
        return providers;
    }

    public ExcludeDatanodeManager getExcludeDatanodeManager() {
        return this.excludeDatanodeManager;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public String getFactoryId() {
        return this.factoryId;
    }

    static enum Providers {
        defaultProvider(AsyncFSWALProvider.class),
        filesystem(FSHLogProvider.class),
        multiwal(RegionGroupingProvider.class),
        asyncfs(AsyncFSWALProvider.class);

        final Class<? extends WALProvider> clazz;

        private Providers(Class<? extends WALProvider> clazz) {
            this.clazz = clazz;
        }
    }
}

